/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.component.cxf;

import java.awt.Image;

import jakarta.xml.ws.BindingType;
import jakarta.xml.ws.Holder;

import org.apache.camel.cxf.mtom_feature.Hello;

@BindingType(value = jakarta.xml.ws.soap.SOAPBinding.SOAP11HTTP_MTOM_BINDING)
public class HelloImpl implements Hello {
    public void detail(Holder<byte[]> photo, Holder<Image> image) {
        // echo through Holder
    }

    public void echoData(Holder<byte[]> data) {
        // echo through Holder
    }
}
