/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.connection.ui.widgets;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import org.apache.directory.api.util.FileUtils;
import org.apache.directory.api.util.Strings;
import org.apache.directory.studio.common.ui.widgets.BaseWidgetUtils;
import org.apache.directory.studio.connection.core.StudioKeyStoreManager;
import org.apache.directory.studio.connection.ui.ConnectionUIPlugin;
import org.apache.directory.studio.connection.ui.dialogs.CertificateInfoDialog;
import org.apache.directory.studio.connection.ui.widgets.Messages;
import org.apache.directory.studio.connection.ui.wizards.ExportCertificateWizard;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class CertificateListComposite
extends Composite {
    private StudioKeyStoreManager keyStoreManager;
    private TableViewer tableViewer;
    private Button viewButton;
    private Button addButton;
    private Button removeButton;
    private Button exportButton;
    private ISelectionChangedListener tableViewerSelectionListener = event -> {
        this.viewButton.setEnabled(((IStructuredSelection)event.getSelection()).size() == 1);
        this.removeButton.setEnabled(!event.getSelection().isEmpty());
        this.exportButton.setEnabled(((IStructuredSelection)event.getSelection()).size() == 1);
    };
    private IDoubleClickListener tableViewerDoubleClickListener = event -> this.openCertificate(event.getSelection());
    private SelectionAdapter viewButtonSelectionListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent event) {
            CertificateListComposite.this.openCertificate(CertificateListComposite.this.tableViewer.getSelection());
        }
    };
    private SelectionAdapter addButtonSelectionListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent event) {
            FileDialog dialog = new FileDialog(CertificateListComposite.this.getShell(), 4096);
            dialog.setText(Messages.getString("CertificateListComposite.LoadCertificate"));
            String returnedFileName = dialog.open();
            if (returnedFileName != null) {
                try {
                    X509Certificate certificate = CertificateListComposite.generateCertificate(FileUtils.readFileToByteArray((File)new File(returnedFileName)));
                    CertificateListComposite.this.keyStoreManager.addCertificate(certificate);
                    CertificateListComposite.this.tableViewer.refresh();
                    CertificateListComposite.this.tableViewer.setSelection((ISelection)new StructuredSelection((Object)certificate));
                }
                catch (Exception ex) {
                    MessageDialog.openError((Shell)CertificateListComposite.this.addButton.getShell(), (String)Messages.getString("CertificateListComposite.ErrorDialogTitle"), (String)NLS.bind((String)Messages.getString("CertificateListComposite.ErrorDialogMessage"), (Object)ex.getMessage()));
                }
            }
        }
    };
    private SelectionAdapter removeButtonSelectionListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent event) {
            IStructuredSelection selection = (IStructuredSelection)CertificateListComposite.this.tableViewer.getSelection();
            for (X509Certificate certificate : selection) {
                try {
                    CertificateListComposite.this.keyStoreManager.removeCertificate(certificate);
                }
                catch (CertificateException ce) {
                    throw new RuntimeException(ce);
                }
            }
            CertificateListComposite.this.tableViewer.refresh();
        }
    };
    private SelectionAdapter exportButtonSelectionListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent event) {
            X509Certificate certificate = (X509Certificate)((IStructuredSelection)CertificateListComposite.this.tableViewer.getSelection()).getFirstElement();
            WizardDialog dialog = new WizardDialog(CertificateListComposite.this.getShell(), (IWizard)new ExportCertificateWizard(certificate));
            dialog.open();
        }
    };

    public CertificateListComposite(Composite parent, int style) {
        super(parent, style);
        GridLayout layout = new GridLayout(1, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        this.setLayout((Layout)layout);
        this.setLayoutData(new GridData(4, 4, true, true));
        Composite container = new Composite((Composite)this, 0);
        layout = new GridLayout(2, false);
        container.setLayout((Layout)layout);
        container.setLayoutData((Object)new GridData(4, 4, true, true));
        this.tableViewer = new TableViewer(container, 2818);
        GridData gridData = new GridData(4, 4, true, true);
        gridData.widthHint = 360;
        gridData.heightHint = 10;
        this.tableViewer.getTable().setLayoutData((Object)gridData);
        this.tableViewer.setContentProvider((IContentProvider)new KeyStoreContentProvider());
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new KeyStoreLabelProvider());
        this.tableViewer.addSelectionChangedListener(this.tableViewerSelectionListener);
        this.tableViewer.addDoubleClickListener(this.tableViewerDoubleClickListener);
        this.createButtons(container);
    }

    private void createButtons(Composite container) {
        Composite buttonContainer = BaseWidgetUtils.createColumnContainer((Composite)container, (int)1, (int)1);
        buttonContainer.setLayoutData((Object)new GridData(4, 4, false, false));
        this.viewButton = BaseWidgetUtils.createButton((Composite)buttonContainer, (String)Messages.getString("CertificateListComposite.ViewButton"), (int)1);
        this.viewButton.setEnabled(false);
        this.viewButton.addSelectionListener((SelectionListener)this.viewButtonSelectionListener);
        this.addButton = BaseWidgetUtils.createButton((Composite)buttonContainer, (String)Messages.getString("CertificateListComposite.AddButton"), (int)1);
        this.addButton.addSelectionListener((SelectionListener)this.addButtonSelectionListener);
        this.removeButton = BaseWidgetUtils.createButton((Composite)buttonContainer, (String)Messages.getString("CertificateListComposite.RemoveButton"), (int)1);
        this.removeButton.setEnabled(false);
        this.removeButton.addSelectionListener((SelectionListener)this.removeButtonSelectionListener);
        this.exportButton = BaseWidgetUtils.createButton((Composite)buttonContainer, (String)Messages.getString("CertificateListComposite.ExportButton"), (int)1);
        this.exportButton.setEnabled(false);
        this.exportButton.addSelectionListener((SelectionListener)this.exportButtonSelectionListener);
    }

    private static X509Certificate generateCertificate(byte[] data) throws CertificateException {
        CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
        Certificate certificate = certificateFactory.generateCertificate(new ByteArrayInputStream(data));
        if (certificate instanceof X509Certificate) {
            return (X509Certificate)certificate;
        }
        return null;
    }

    public void setInput(StudioKeyStoreManager keyStoreManager) {
        this.keyStoreManager = keyStoreManager;
        this.tableViewer.setInput((Object)keyStoreManager);
    }

    private void openCertificate(ISelection selection) {
        IStructuredSelection structuredSelection = (IStructuredSelection)selection;
        X509Certificate certificate = (X509Certificate)structuredSelection.getFirstElement();
        new CertificateInfoDialog(this.getShell(), new X509Certificate[]{certificate}).open();
    }

    private class KeyStoreContentProvider
    implements IStructuredContentProvider {
        private KeyStoreContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof StudioKeyStoreManager) {
                try {
                    return ((StudioKeyStoreManager)inputElement).getCertificates();
                }
                catch (CertificateException e) {
                    throw new RuntimeException(e);
                }
            }
            return new Object[0];
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    class KeyStoreLabelProvider
    extends LabelProvider {
        KeyStoreLabelProvider() {
        }

        public String getText(Object element) {
            if (element instanceof X509Certificate) {
                X509Certificate certificate = (X509Certificate)element;
                String certificateName = certificate.getSubjectX500Principal().getName();
                if (Strings.isEmpty((String)certificateName)) {
                    return Messages.getString("CertificateListComposite.UntitledCertificate");
                }
                return certificateName;
            }
            return super.getText(element);
        }

        public Image getImage(Object element) {
            if (element instanceof X509Certificate) {
                return ConnectionUIPlugin.getDefault().getImage("resources/icons/certificate.gif");
            }
            return super.getImage(element);
        }
    }
}

