/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.rowset;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.resultset.ResultSetLang;
import org.apache.jena.riot.rowset.RowSetReader;
import org.apache.jena.riot.rowset.RowSetReaderFactory;
import org.apache.jena.riot.rowset.rw.RowSetReaderCSV;
import org.apache.jena.riot.rowset.rw.RowSetReaderJSONStreaming;
import org.apache.jena.riot.rowset.rw.RowSetReaderNone;
import org.apache.jena.riot.rowset.rw.RowSetReaderProtobuf;
import org.apache.jena.riot.rowset.rw.RowSetReaderTSV;
import org.apache.jena.riot.rowset.rw.RowSetReaderThrift;
import org.apache.jena.riot.rowset.rw.RowSetReaderXML;

public class RowSetReaderRegistry {
    private static Map<Lang, RowSetReaderFactory> registry = new HashMap<Lang, RowSetReaderFactory>();
    private static boolean initialized = false;

    public static RowSetReaderFactory getFactory(Lang lang) {
        Objects.requireNonNull(lang);
        return registry.get(lang);
    }

    public static RowSetReader createReader(Lang lang) {
        Objects.requireNonNull(lang);
        RowSetReaderFactory factory = RowSetReaderRegistry.getFactory(lang);
        if (factory == null) {
            return null;
        }
        return factory.create(lang);
    }

    public static void register(Lang lang, RowSetReaderFactory factory) {
        Objects.requireNonNull(lang);
        Objects.requireNonNull(factory);
        registry.put(lang, factory);
    }

    public static boolean isRegistered(Lang lang) {
        Objects.requireNonNull(lang);
        return registry.containsKey(lang);
    }

    public static void init() {
        if (initialized) {
            return;
        }
        initialized = true;
        RowSetReaderRegistry.register(ResultSetLang.RS_XML, RowSetReaderXML.factory);
        RowSetReaderRegistry.register(ResultSetLang.RS_JSON, RowSetReaderJSONStreaming.factory);
        RowSetReaderRegistry.register(ResultSetLang.RS_CSV, RowSetReaderCSV.factory);
        RowSetReaderRegistry.register(ResultSetLang.RS_TSV, RowSetReaderTSV.factory);
        RowSetReaderRegistry.register(ResultSetLang.RS_Thrift, RowSetReaderThrift.factory);
        RowSetReaderRegistry.register(ResultSetLang.RS_Protobuf, RowSetReaderProtobuf.factory);
        RowSetReaderRegistry.register(ResultSetLang.RS_None, RowSetReaderNone.factory);
    }
}

