/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j;

import org.apache.log4j.Level;
import org.apache.log4j.helpers.OptionConverter;

public class Priority {
    public static final int OFF_INT = Integer.MAX_VALUE;
    public static final int FATAL_INT = 50000;
    public static final int ERROR_INT = 40000;
    public static final int WARN_INT = 30000;
    public static final int INFO_INT = 20000;
    public static final int DEBUG_INT = 10000;
    public static final int ALL_INT = Integer.MIN_VALUE;
    @Deprecated
    public static final Priority FATAL = new Priority(50000, "FATAL", 0, org.apache.logging.log4j.Level.FATAL);
    @Deprecated
    public static final Priority ERROR = new Priority(40000, "ERROR", 3, org.apache.logging.log4j.Level.ERROR);
    @Deprecated
    public static final Priority WARN = new Priority(30000, "WARN", 4, org.apache.logging.log4j.Level.WARN);
    @Deprecated
    public static final Priority INFO = new Priority(20000, "INFO", 6, org.apache.logging.log4j.Level.INFO);
    @Deprecated
    public static final Priority DEBUG = new Priority(10000, "DEBUG", 7, org.apache.logging.log4j.Level.DEBUG);
    transient int level;
    transient String levelStr;
    transient int syslogEquivalent;
    transient org.apache.logging.log4j.Level version2Level;

    protected Priority() {
        this(10000, "DEBUG", 7, org.apache.logging.log4j.Level.DEBUG);
    }

    protected Priority(int level, String levelStr, int syslogEquivalent) {
        this(level, levelStr, syslogEquivalent, null);
    }

    Priority(int level, String levelStr, int syslogEquivalent, org.apache.logging.log4j.Level version2Equivalent) {
        this.level = level;
        this.levelStr = levelStr;
        this.syslogEquivalent = syslogEquivalent;
        this.version2Level = version2Equivalent != null ? version2Equivalent : OptionConverter.createLevel(this);
    }

    public boolean equals(Object o) {
        if (o instanceof Priority) {
            Priority r = (Priority)o;
            return this.level == r.level;
        }
        return false;
    }

    public int hashCode() {
        return this.level;
    }

    public final int getSyslogEquivalent() {
        return this.syslogEquivalent;
    }

    public org.apache.logging.log4j.Level getVersion2Level() {
        return this.version2Level;
    }

    public boolean isGreaterOrEqual(Priority r) {
        return this.level >= r.level;
    }

    @Deprecated
    public static Priority[] getAllPossiblePriorities() {
        return new Priority[]{FATAL, ERROR, Level.WARN, INFO, DEBUG};
    }

    public final String toString() {
        return this.levelStr;
    }

    public final int toInt() {
        return this.level;
    }

    @Deprecated
    public static Priority toPriority(String sArg) {
        return Level.toLevel(sArg);
    }

    @Deprecated
    public static Priority toPriority(int val) {
        return Priority.toPriority(val, DEBUG);
    }

    @Deprecated
    public static Priority toPriority(int val, Priority defaultPriority) {
        Level result = Level.toLevel(val, null);
        return result == null ? defaultPriority : result;
    }

    @Deprecated
    public static Priority toPriority(String sArg, Priority defaultPriority) {
        Level result = Level.toLevel(sArg, null);
        return result == null ? defaultPriority : result;
    }
}

