/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.authentication;

import java.util.Collections;
import java.util.Optional;
import lombok.Generated;
import org.apereo.cas.authentication.AuthenticationBuilder;
import org.apereo.cas.authentication.AuthenticationException;
import org.apereo.cas.authentication.AuthenticationPostProcessor;
import org.apereo.cas.authentication.AuthenticationTransaction;
import org.apereo.cas.authentication.Credential;
import org.apereo.cas.authentication.credential.UsernamePasswordCredential;
import org.apereo.cas.configuration.model.support.ldap.AbstractLdapProperties;
import org.apereo.cas.configuration.model.support.ldap.AbstractLdapSearchProperties;
import org.apereo.cas.util.LdapConnectionFactory;
import org.apereo.cas.util.LdapUtils;
import org.apereo.cas.util.LoggingUtils;
import org.ldaptive.AttributeModification;
import org.ldaptive.FilterTemplate;
import org.ldaptive.LdapAttribute;
import org.ldaptive.ModifyOperation;
import org.ldaptive.ModifyRequest;
import org.ldaptive.ModifyResponse;
import org.ldaptive.ResultCode;
import org.ldaptive.SearchResponse;
import org.ldaptive.ad.UnicodePwdAttribute;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;

public class LdapPasswordSynchronizationAuthenticationPostProcessor
implements AuthenticationPostProcessor,
DisposableBean {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(LdapPasswordSynchronizationAuthenticationPostProcessor.class);
    private final LdapConnectionFactory searchFactory;
    private final AbstractLdapSearchProperties ldapProperties;

    public LdapPasswordSynchronizationAuthenticationPostProcessor(AbstractLdapSearchProperties properties) {
        this.ldapProperties = properties;
        this.searchFactory = new LdapConnectionFactory(LdapUtils.newLdaptiveConnectionFactory((AbstractLdapProperties)properties));
    }

    public void destroy() {
        this.searchFactory.close();
    }

    public void process(AuthenticationBuilder builder, AuthenticationTransaction transaction) throws AuthenticationException {
        Optional primaryCredential = transaction.getPrimaryCredential();
        if (primaryCredential.isEmpty()) {
            LOGGER.warn("Current authentication transaction does not have a primary credential");
            return;
        }
        try {
            UsernamePasswordCredential credential = (UsernamePasswordCredential)UsernamePasswordCredential.class.cast(primaryCredential.get());
            FilterTemplate filter = LdapUtils.newLdaptiveSearchFilter(this.ldapProperties.getSearchFilter(), "user", Collections.singletonList(credential.getUsername()));
            LOGGER.trace("Constructed LDAP filter [{}] to locate user and update password", (Object)filter);
            SearchResponse response = this.searchFactory.executeSearchOperation(this.ldapProperties.getBaseDn(), filter, this.ldapProperties.getPageSize());
            LOGGER.debug("LDAP response is [{}]", (Object)response);
            if (LdapUtils.containsResultEntry(response)) {
                boolean result;
                String dn = response.getEntry().getDn();
                LOGGER.trace("Updating account password for [{}]", (Object)dn);
                ModifyOperation operation = new ModifyOperation(this.searchFactory.getConnectionFactory());
                AttributeModification mod = new AttributeModification(AttributeModification.Type.REPLACE, this.getLdapPasswordAttribute(credential));
                ModifyResponse updateResponse = operation.execute(new ModifyRequest(dn, new AttributeModification[]{mod}));
                LOGGER.trace("Result code [{}], message: [{}]", (Object)response.getResultCode(), (Object)response.getDiagnosticMessage());
                boolean bl = result = updateResponse.getResultCode() == ResultCode.SUCCESS;
                if (result) {
                    LOGGER.info("Updated the LDAP entry's password for [{}] and base DN [{}]", (Object)filter.format(), (Object)this.ldapProperties.getBaseDn());
                } else {
                    LOGGER.warn("Could not update the LDAP entry's password for [{}] and base DN [{}]", (Object)filter.format(), (Object)this.ldapProperties.getBaseDn());
                }
            } else {
                LOGGER.error("Could not locate an LDAP entry for [{}] and base DN [{}]", (Object)filter.format(), (Object)this.ldapProperties.getBaseDn());
            }
        }
        catch (Exception e) {
            LoggingUtils.error((Logger)LOGGER, (Throwable)e);
        }
    }

    public boolean supports(Credential credential) {
        return credential instanceof UsernamePasswordCredential;
    }

    protected LdapAttribute getLdapPasswordAttribute(UsernamePasswordCredential credential) {
        return new UnicodePwdAttribute(new String[]{credential.toPassword()});
    }
}

