/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.oauth2.useragent;

import com.microsoft.alm.oauth2.useragent.AuthorizationException;
import com.microsoft.alm.oauth2.useragent.AuthorizationResponse;
import com.microsoft.alm.oauth2.useragent.UserAgentImpl;
import com.microsoft.alm.oauth2.useragent.utils.StringHelper;
import java.net.URI;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javafx.application.Platform;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.concurrent.Worker;
import javafx.scene.layout.Region;
import javafx.scene.web.WebEngine;
import javafx.scene.web.WebView;

class InterceptingBrowser
extends Region
implements ChangeListener<String> {
    private final Lock lock = new ReentrantLock();
    private final Condition responseReceived = this.lock.newCondition();
    private final WebView webView = new WebView();
    private final WebEngine webEngine = this.webView.getEngine();
    private String destinationUriString;
    private String redirectUriString;
    private String response;

    public InterceptingBrowser() {
        this.webEngine.locationProperty().addListener((ChangeListener)this);
        final Worker loadWorker = this.webEngine.getLoadWorker();
        loadWorker.stateProperty().addListener((ChangeListener)new ChangeListener<Worker.State>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void changed(ObservableValue<? extends Worker.State> observable, Worker.State oldValue, Worker.State newValue) {
                InterceptingBrowser.this.lock.lock();
                try {
                    if (Worker.State.FAILED.equals((Object)newValue)) {
                        Throwable exception = loadWorker.getException();
                        if (exception != null) {
                            InterceptingBrowser.this.response = AuthorizationException.toString("load_error", exception, null);
                        } else {
                            InterceptingBrowser.this.response = AuthorizationException.toString("load_error", "Exception details were not available", null);
                        }
                        InterceptingBrowser.this.responseReceived.signal();
                    }
                }
                finally {
                    InterceptingBrowser.this.lock.unlock();
                }
            }
        });
        this.getChildren().add((Object)this.webView);
    }

    public WebEngine getWebEngine() {
        return this.webEngine;
    }

    public String toString() {
        return "destinationUri: " + this.destinationUriString + " redirectUri: " + this.redirectUriString;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
        this.lock.lock();
        try {
            if (InterceptingBrowser.matchesRedirection(this.redirectUriString, newValue)) {
                this.response = UserAgentImpl.extractResponseFromRedirectUri(newValue);
                this.responseReceived.signal();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    static boolean matchesRedirection(String expectedRedirectUriString, String actualUriString) {
        if (actualUriString == null) {
            return false;
        }
        URI actualUri = URI.create(actualUriString);
        URI expectedUri = URI.create(expectedRedirectUriString);
        if (!StringHelper.equalIgnoringCase(expectedUri.getScheme(), actualUri.getScheme())) {
            return false;
        }
        if (!StringHelper.equalIgnoringCase(expectedUri.getHost(), actualUri.getHost())) {
            return false;
        }
        if (expectedUri.getPort() != actualUri.getPort()) {
            return false;
        }
        String actualPath = actualUri.getPath();
        String expectedPath = expectedUri.getPath();
        if (actualPath != null) {
            if (expectedPath == null) {
                return false;
            }
            if (!actualPath.startsWith(expectedPath)) {
                return false;
            }
        } else if (expectedPath != null) {
            return false;
        }
        return !actualUri.getScheme().equals("urn") || actualUriString.startsWith(expectedRedirectUriString);
    }

    public void sendRequest(URI destinationUri, URI redirectUri) {
        this.destinationUriString = destinationUri.toString();
        this.redirectUriString = redirectUri.toString();
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                InterceptingBrowser.this.webEngine.load(InterceptingBrowser.this.destinationUriString);
            }
        });
    }

    public AuthorizationResponse waitForResponse() throws AuthorizationException {
        this.lock.lock();
        try {
            this.responseReceived.awaitUninterruptibly();
            AuthorizationResponse authorizationResponse = AuthorizationResponse.fromString(this.response);
            return authorizationResponse;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void cancel() {
        this.lock.lock();
        try {
            this.response = "error=cancelled&error_description=The browser window was closed by the user.";
            this.responseReceived.signal();
        }
        finally {
            this.lock.unlock();
        }
    }
}

