/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.job.service.impl.cmd;

import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.api.FlowableIllegalArgumentException;
import org.flowable.common.engine.impl.interceptor.Command;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.job.api.JobNotFoundException;
import org.flowable.job.service.JobServiceConfiguration;
import org.flowable.job.service.impl.persistence.entity.HistoryJobEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecuteHistoryJobCmd
implements Command<Void> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExecuteHistoryJobCmd.class);
    protected JobServiceConfiguration jobServiceConfiguration;
    protected String historyJobId;

    public ExecuteHistoryJobCmd(String historyJobId, JobServiceConfiguration jobServiceConfiguration) {
        this.historyJobId = historyJobId;
        this.jobServiceConfiguration = jobServiceConfiguration;
    }

    public Void execute(CommandContext commandContext) {
        if (this.historyJobId == null) {
            throw new FlowableIllegalArgumentException("historyJobId is null");
        }
        HistoryJobEntity historyJobEntity = (HistoryJobEntity)this.jobServiceConfiguration.getHistoryJobEntityManager().findById(this.historyJobId);
        if (historyJobEntity == null) {
            throw new JobNotFoundException(this.historyJobId);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Executing historyJob {}", (Object)historyJobEntity.getId());
        }
        try {
            this.jobServiceConfiguration.getJobManager().execute(historyJobEntity);
        }
        catch (Throwable exception) {
            throw new FlowableException("HistoryJob " + this.historyJobId + " failed", exception);
        }
        return null;
    }
}

