/*
 * Decompiled with CFR 0.152.
 */
package net.tirasa.connid.bundles.csvdir.methods;

import java.sql.ResultSet;
import java.sql.SQLException;
import net.tirasa.connid.bundles.csvdir.CSVDirConfiguration;
import net.tirasa.connid.bundles.csvdir.CSVDirConnection;
import org.identityconnectors.common.logging.Log;
import org.identityconnectors.framework.common.exceptions.ConnectorException;
import org.identityconnectors.framework.common.objects.ObjectClass;

public class CSVDirTest {
    private static final Log LOG = Log.getLog(CSVDirTest.class);
    private final CSVDirConfiguration conf;

    public CSVDirTest(CSVDirConfiguration conf) throws ClassNotFoundException, SQLException {
        this.conf = conf;
    }

    public void execute() {
        CSVDirConnection conn = null;
        ResultSet resultSet = null;
        try {
            conn = CSVDirConnection.open(this.conf);
            resultSet = conn.allCsvFiles(new ObjectClass(this.conf.getObjectClass()[0]));
            if (resultSet == null || resultSet.wasNull()) {
                throw new ConnectorException("Test failed");
            }
        }
        catch (Exception e) {
            LOG.error((Throwable)e, "error during test connection", new Object[0]);
            throw new ConnectorException((Throwable)e);
        }
        finally {
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (SQLException sQLException) {}
            }
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }
}

