/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.authentication;

import java.util.Optional;
import lombok.Generated;
import org.apereo.cas.authentication.AuthenticationBuilder;
import org.apereo.cas.authentication.AuthenticationTransaction;
import org.apereo.cas.authentication.Credential;
import org.apereo.cas.authentication.SurrogateAuthenticationException;
import org.apereo.cas.authentication.SurrogateUsernamePasswordCredential;
import org.apereo.cas.authentication.metadata.BaseAuthenticationMetaDataPopulator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SurrogateAuthenticationMetaDataPopulator
extends BaseAuthenticationMetaDataPopulator {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(SurrogateAuthenticationMetaDataPopulator.class);

    public void populateAttributes(AuthenticationBuilder builder, AuthenticationTransaction transaction) {
        Optional credential = transaction.getPrimaryCredential();
        if (credential.isEmpty()) {
            throw new SurrogateAuthenticationException("The authentication transaction does not have a primary principal associated with it");
        }
        SurrogateUsernamePasswordCredential current = (SurrogateUsernamePasswordCredential)((Object)SurrogateUsernamePasswordCredential.class.cast(credential.get()));
        LOGGER.debug("Recording surrogate username [{}] as an authentication attribute", (Object)current.getSurrogateUsername());
        builder.addAttribute("surrogateUser", (Object)current.getSurrogateUsername());
        builder.addAttribute("surrogatePrincipal", (Object)current.getId());
        builder.addAttribute("surrogateEnabled", (Object)Boolean.TRUE.toString());
    }

    public boolean supports(Credential credential) {
        return credential != null && SurrogateUsernamePasswordCredential.class.isAssignableFrom(credential.getClass());
    }
}

