/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.oidc.web;

import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.apache.http.client.utils.URIBuilder;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.support.oidc.OidcDiscoveryProperties;
import org.apereo.cas.oidc.issuer.OidcIssuerService;
import org.apereo.cas.services.OidcRegisteredService;
import org.apereo.cas.support.oauth.services.OAuthRegisteredService;
import org.apereo.cas.support.oauth.web.response.callback.DefaultOAuth20AuthorizationModelAndViewBuilder;

public class OidcAuthorizationModelAndViewBuilder
extends DefaultOAuth20AuthorizationModelAndViewBuilder {
    private final OidcIssuerService issuerService;
    private final CasConfigurationProperties casProperties;

    protected String prepareRedirectUrl(OAuthRegisteredService registeredService, String redirectUrl, Map<String, String> parameters) throws Exception {
        OidcDiscoveryProperties discovery = this.casProperties.getAuthn().getOidc().getDiscovery();
        if (registeredService instanceof OidcRegisteredService && discovery.isAuthorizationResponseIssuerParameterSupported()) {
            OidcRegisteredService oidcService = (OidcRegisteredService)registeredService;
            String issuer = this.issuerService.determineIssuer(Optional.of(oidcService));
            parameters.put("iss", issuer);
            return new URIBuilder(redirectUrl).addParameter("iss", issuer).build().toString();
        }
        return super.prepareRedirectUrl(registeredService, redirectUrl, parameters);
    }

    @Generated
    public OidcAuthorizationModelAndViewBuilder(OidcIssuerService issuerService, CasConfigurationProperties casProperties) {
        this.issuerService = issuerService;
        this.casProperties = casProperties;
    }
}

