/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.oauth.web.response.accesstoken.ext;

import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.authentication.principal.WebApplicationService;
import org.apereo.cas.services.UnauthorizedServiceException;
import org.apereo.cas.support.oauth.OAuth20GrantTypes;
import org.apereo.cas.support.oauth.OAuth20ResponseTypes;
import org.apereo.cas.support.oauth.services.OAuthRegisteredService;
import org.apereo.cas.support.oauth.util.OAuth20Utils;
import org.apereo.cas.support.oauth.web.endpoints.OAuth20ConfigurationContext;
import org.apereo.cas.support.oauth.web.response.accesstoken.ext.AccessTokenRequestContext;
import org.apereo.cas.support.oauth.web.response.accesstoken.ext.BaseAccessTokenGrantRequestExtractor;
import org.apereo.cas.ticket.OAuth20Token;
import org.apereo.cas.util.function.FunctionUtils;
import org.pac4j.core.context.WebContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AccessTokenAuthorizationCodeGrantRequestExtractor
extends BaseAccessTokenGrantRequestExtractor {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(AccessTokenAuthorizationCodeGrantRequestExtractor.class);

    public AccessTokenAuthorizationCodeGrantRequestExtractor(OAuth20ConfigurationContext config) {
        super(config);
    }

    protected static boolean isAllowedToGenerateRefreshToken() {
        return true;
    }

    @Override
    public AccessTokenRequestContext extractRequest(WebContext context) {
        Optional grantType = this.getConfigurationContext().getRequestParameterResolver().resolveRequestParameter(context, "grant_type");
        LOGGER.debug("OAuth grant type is [{}]", (Object)grantType);
        String redirectUri = this.getRegisteredServiceIdentifierFromRequest(context);
        OAuthRegisteredService registeredService = this.getOAuthRegisteredServiceBy(context);
        FunctionUtils.throwIf((registeredService == null ? 1 : 0) != 0, () -> new UnauthorizedServiceException("Unable to locate service in registry for redirect URI " + redirectUri));
        Set requestedScopes = this.getConfigurationContext().getRequestParameterResolver().resolveRequestScopes(context);
        LOGGER.debug("Requested scopes are [{}]", (Object)requestedScopes);
        OAuth20Token token = this.getOAuthTokenFromRequest(context);
        this.ensureTicketGrantingTicketIsNotExpired(token);
        Set<String> scopes = this.extractRequestedScopesByToken(requestedScopes, token, context);
        WebApplicationService service = (WebApplicationService)this.getConfigurationContext().getWebApplicationServiceServiceFactory().createService(redirectUri);
        boolean generateRefreshToken = AccessTokenAuthorizationCodeGrantRequestExtractor.isAllowedToGenerateRefreshToken() && registeredService.isGenerateRefreshToken();
        AccessTokenRequestContext.AccessTokenRequestContextBuilder builder = AccessTokenRequestContext.builder().scopes(scopes).service((Service)service).authentication(token.getAuthentication()).registeredService(registeredService).grantType(this.getGrantType()).generateRefreshToken(generateRefreshToken).token(token).claims(token.getClaims()).ticketGrantingTicket(token.getTicketGrantingTicket());
        return this.extractInternal(context, builder);
    }

    public boolean supports(WebContext context) {
        String grantType = this.getConfigurationContext().getRequestParameterResolver().resolveRequestParameter(context, "grant_type").orElse("");
        return OAuth20Utils.isGrantType(grantType, this.getGrantType());
    }

    public OAuth20GrantTypes getGrantType() {
        return OAuth20GrantTypes.AUTHORIZATION_CODE;
    }

    public OAuth20ResponseTypes getResponseType() {
        return OAuth20ResponseTypes.NONE;
    }

    protected boolean ensureTicketGrantingTicketIsNotExpired(OAuth20Token token) {
        return token.isCode() && this.getConfigurationContext().getTicketRegistry().getTicket(token.getTicketGrantingTicket().getId()) != null;
    }

    protected Set<String> extractRequestedScopesByToken(Set<String> requestedScopes, OAuth20Token token, WebContext context) {
        TreeSet<String> scopes = new TreeSet<String>(requestedScopes);
        scopes.addAll(token.getScopes());
        return scopes;
    }

    protected AccessTokenRequestContext extractInternal(WebContext context, AccessTokenRequestContext.AccessTokenRequestContextBuilder builder) {
        return builder.build();
    }

    protected String getRegisteredServiceIdentifierFromRequest(WebContext context) {
        return this.getConfigurationContext().getRequestParameterResolver().resolveRequestParameter(context, "redirect_uri").orElse("");
    }

    protected String getOAuthParameterName() {
        return "code";
    }

    protected String getOAuthParameter(WebContext context) {
        return this.getConfigurationContext().getRequestParameterResolver().resolveRequestParameter(context, this.getOAuthParameterName()).orElse("");
    }

    protected OAuth20Token getOAuthTokenFromRequest(WebContext context) {
        String id = this.getOAuthParameter(context);
        return (OAuth20Token)this.getConfigurationContext().getTicketRegistry().getTicket(id, OAuth20Token.class);
    }

    protected OAuthRegisteredService getOAuthRegisteredServiceBy(WebContext context) {
        String clientId = (String)this.getConfigurationContext().getRequestParameterResolver().resolveClientIdAndClientSecret(context, this.getConfigurationContext().getSessionStore()).getLeft();
        String redirectUri = this.getRegisteredServiceIdentifierFromRequest(context);
        OAuthRegisteredService registeredService = StringUtils.isNotBlank((CharSequence)clientId) ? OAuth20Utils.getRegisteredOAuthServiceByClientId(this.getConfigurationContext().getServicesManager(), clientId) : OAuth20Utils.getRegisteredOAuthServiceByRedirectUri(this.getConfigurationContext().getServicesManager(), redirectUri);
        FunctionUtils.doIf((registeredService == null ? 1 : 0) != 0, param -> LOGGER.warn("Unable to locate registered service for clientId [{}] or redirectUri [{}]", (Object)clientId, (Object)redirectUri), ex -> LOGGER.debug("Located registered service [{}]", (Object)registeredService)).accept(registeredService);
        return registeredService;
    }
}

