/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.pac4j.authentication.clients;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.benmanes.caffeine.cache.Cache;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpResponse;
import org.apereo.cas.authentication.CasSSLContext;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.support.pac4j.Pac4jDelegatedAuthenticationRestfulProperties;
import org.apereo.cas.support.pac4j.authentication.clients.BaseDelegatedClientFactory;
import org.apereo.cas.support.pac4j.authentication.clients.DelegatedClientFactoryCustomizer;
import org.apereo.cas.util.HttpUtils;
import org.apereo.cas.util.function.FunctionUtils;
import org.apereo.cas.util.serialization.JacksonObjectMapperFactory;
import org.hjson.JsonValue;
import org.pac4j.config.client.PropertiesConfigFactory;
import org.pac4j.core.client.IndirectClient;
import org.pac4j.saml.store.SAMLMessageStoreFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.context.properties.bind.BindResult;
import org.springframework.boot.context.properties.bind.Bindable;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.boot.context.properties.source.ConfigurationPropertySources;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.PropertySource;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;

public class RestfulDelegatedClientFactory
extends BaseDelegatedClientFactory {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(RestfulDelegatedClientFactory.class);
    private static final ObjectMapper MAPPER = JacksonObjectMapperFactory.builder().defaultTypingEnabled(false).build().toObjectMapper();

    public RestfulDelegatedClientFactory(Collection<DelegatedClientFactoryCustomizer> customizers, CasSSLContext casSSLContext, CasConfigurationProperties casProperties, ObjectProvider<SAMLMessageStoreFactory> samlMessageStoreFactory, Cache<String, Collection<IndirectClient>> clientsCache) {
        super(casProperties, customizers, casSSLContext, samlMessageStoreFactory, clientsCache);
    }

    @Override
    protected Collection<IndirectClient> loadClients() {
        Pac4jDelegatedAuthenticationRestfulProperties restProperties = this.casProperties.getAuthn().getPac4j().getRest();
        HttpUtils.HttpExecutionRequest exec = HttpUtils.HttpExecutionRequest.builder().basicAuthPassword(restProperties.getBasicAuthPassword()).basicAuthUsername(restProperties.getBasicAuthUsername()).method(HttpMethod.valueOf((String)restProperties.getMethod().toUpperCase().trim())).url(restProperties.getUrl()).parameters(Map.of("type", restProperties.getType())).headers(restProperties.getHeaders()).build();
        return (Collection)FunctionUtils.doAndRetry(callback -> {
            HttpResponse response = HttpUtils.execute((HttpUtils.HttpExecutionRequest)exec);
            try {
                if (response != null && HttpStatus.valueOf((int)response.getStatusLine().getStatusCode()).is2xxSuccessful()) {
                    try (InputStream content = response.getEntity().getContent();){
                        String result = IOUtils.toString((InputStream)content, (Charset)StandardCharsets.UTF_8);
                        switch (restProperties.getType().toLowerCase()) {
                            case "cas": {
                                Collection<IndirectClient> collection = this.buildClientsBasedCasProperties(result);
                                return collection;
                            }
                        }
                        List<IndirectClient> list = this.buildClientsBasedPac4jProperties(result);
                        return list;
                    }
                }
                ArrayList arrayList = new ArrayList();
                return arrayList;
            }
            finally {
                HttpUtils.close((HttpResponse)response);
            }
        });
    }

    protected Collection<IndirectClient> buildClientsBasedCasProperties(String result) throws Exception {
        Map payload = (Map)MAPPER.readValue(JsonValue.readHjson((String)result).toString(), Map.class);
        LOGGER.trace("CAS properties received as [{}]", (Object)payload);
        Binder binder = new Binder(ConfigurationPropertySources.from((PropertySource)new MapPropertySource(this.getClass().getSimpleName(), payload)));
        BindResult bound = binder.bind("cas", Bindable.of(CasConfigurationProperties.class));
        if (bound.isBound()) {
            CasConfigurationProperties properties = (CasConfigurationProperties)bound.get();
            return this.buildAllIdentityProviders(properties);
        }
        return List.of();
    }

    protected List<IndirectClient> buildClientsBasedPac4jProperties(String result) throws Exception {
        Map clients = (Map)MAPPER.readValue(JsonValue.readHjson((String)result).toString(), Map.class);
        LOGGER.trace("Delegated clients received are [{}]", (Object)clients);
        String callbackUrl = clients.getOrDefault("callbackUrl", null);
        Map properties = clients.getOrDefault("properties", new HashMap(0));
        PropertiesConfigFactory factory = new PropertiesConfigFactory(callbackUrl, properties);
        return factory.build(new Object[0]).getClients().findAllClients().stream().map(IndirectClient.class::cast).collect(Collectors.toList());
    }
}

