/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.saml.profile.impl;

import java.util.Optional;
import org.opensaml.saml.common.SAMLObject;
import org.opensaml.saml.common.messaging.context.SAMLBindingContext;
import org.opensaml.saml.common.messaging.context.SAMLPeerEntityContext;
import org.opensaml.saml.saml2.core.StatusResponseType;
import org.opensaml.saml.saml2.metadata.Endpoint;
import org.opensaml.saml.saml2.metadata.EntityDescriptor;
import org.opensaml.saml.saml2.metadata.IDPSSODescriptor;
import org.opensaml.saml.saml2.metadata.RoleDescriptor;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.credentials.Credentials;
import org.pac4j.core.util.CommonHelper;
import org.pac4j.saml.config.SAML2Configuration;
import org.pac4j.saml.context.SAML2MessageContext;
import org.pac4j.saml.exceptions.SAMLException;
import org.pac4j.saml.profile.api.SAML2MessageReceiver;
import org.pac4j.saml.profile.api.SAML2ResponseValidator;
import org.pac4j.saml.transport.AbstractPac4jDecoder;

public abstract class AbstractSAML2MessageReceiver
implements SAML2MessageReceiver {
    protected SAML2ResponseValidator validator;
    protected final SAML2Configuration saml2Configuration;

    public AbstractSAML2MessageReceiver(SAML2ResponseValidator validator, SAML2Configuration saml2Configuration) {
        this.validator = validator;
        this.saml2Configuration = saml2Configuration;
    }

    @Override
    public Credentials receiveMessage(SAML2MessageContext context) {
        context.setSaml2Configuration(this.saml2Configuration);
        SAMLPeerEntityContext peerContext = context.getSAMLPeerEntityContext();
        WebContext webContext = context.getWebContext();
        peerContext.setRole(IDPSSODescriptor.DEFAULT_ELEMENT_NAME);
        context.getSAMLSelfProtocolContext().setProtocol("urn:oasis:names:tc:SAML:2.0:protocol");
        AbstractPac4jDecoder decoder = this.getDecoder(webContext);
        SAML2MessageContext decodedCtx = this.prepareDecodedContext(context, decoder);
        return this.validator.validate(decodedCtx);
    }

    protected SAML2MessageContext prepareDecodedContext(SAML2MessageContext context, AbstractPac4jDecoder decoder) {
        EntityDescriptor metadata;
        SAML2MessageContext decodedCtx = new SAML2MessageContext();
        decodedCtx.setSaml2Configuration(this.saml2Configuration);
        decodedCtx.setMessageContext(decoder.getMessageContext());
        SAMLObject message = (SAMLObject)decoder.getMessageContext().getMessage();
        if (message == null) {
            throw new SAMLException("Response from the context cannot be null");
        }
        decodedCtx.getMessageContext().setMessage((Object)message);
        context.getMessageContext().setMessage((Object)message);
        decodedCtx.setSAMLMessageStore(context.getSAMLMessageStore());
        SAMLBindingContext bindingContext = this.prepareBindingContext(context, decoder, decodedCtx);
        if (decodedCtx.getMessageContext().getMessage() instanceof StatusResponseType) {
            StatusResponseType response = (StatusResponseType)decodedCtx.getMessageContext().getMessage();
            this.getEndpoint(context, response).ifPresent(e -> decodedCtx.getSAMLEndpointContext().setEndpoint(e));
        }
        if ((metadata = context.getSAMLPeerMetadataContext().getEntityDescriptor()) == null) {
            throw new SAMLException("IDP Metadata cannot be null");
        }
        this.preparePeerEntityContext(decoder, decodedCtx, bindingContext, metadata);
        this.prepareSelfEntityContext(context, decodedCtx);
        decodedCtx.getProfileRequestContext().setProfileId(this.getProfileUri());
        decodedCtx.getSAMLSelfMetadataContext().setRoleDescriptor((RoleDescriptor)context.getSPSSODescriptor());
        decodedCtx.setWebContext(context.getWebContext());
        decodedCtx.setSessionStore(context.getSessionStore());
        return decodedCtx;
    }

    protected void prepareSelfEntityContext(SAML2MessageContext context, SAML2MessageContext decodedCtx) {
        decodedCtx.getSAMLSelfEntityContext().setEntityId(context.getSAMLSelfEntityContext().getEntityId());
        decodedCtx.getSAMLSelfEndpointContext().setEndpoint(context.getSAMLSelfEndpointContext().getEndpoint());
        decodedCtx.getSAMLSelfEntityContext().setRole(context.getSAMLSelfEntityContext().getRole());
    }

    protected void preparePeerEntityContext(AbstractPac4jDecoder decoder, SAML2MessageContext decodedCtx, SAMLBindingContext bindingContext, EntityDescriptor metadata) {
        SAMLPeerEntityContext decodedPeerContext = (SAMLPeerEntityContext)decoder.getMessageContext().getSubcontext(SAMLPeerEntityContext.class);
        CommonHelper.assertNotNull((String)"SAMLPeerEntityContext", (Object)bindingContext);
        decodedCtx.getSAMLPeerEntityContext().setEntityId(metadata.getEntityID());
        decodedCtx.getSAMLPeerEntityContext().setAuthenticated(decodedPeerContext != null && decodedPeerContext.isAuthenticated());
    }

    protected SAMLBindingContext prepareBindingContext(SAML2MessageContext context, AbstractPac4jDecoder decoder, SAML2MessageContext decodedCtx) {
        SAMLBindingContext bindingContext = (SAMLBindingContext)decoder.getMessageContext().getSubcontext(SAMLBindingContext.class);
        CommonHelper.assertNotNull((String)"SAMLBindingContext", (Object)bindingContext);
        decodedCtx.getSAMLBindingContext().setBindingDescriptor(bindingContext.getBindingDescriptor());
        decodedCtx.getSAMLBindingContext().setBindingUri(bindingContext.getBindingUri());
        decodedCtx.getSAMLBindingContext().setHasBindingSignature(bindingContext.hasBindingSignature());
        decodedCtx.getSAMLBindingContext().setIntendedDestinationEndpointURIRequired(bindingContext.isIntendedDestinationEndpointURIRequired());
        String relayState = bindingContext.getRelayState();
        decodedCtx.getSAMLBindingContext().setRelayState(relayState);
        context.getSAMLBindingContext().setRelayState(relayState);
        return bindingContext;
    }

    public void setValidator(SAML2ResponseValidator validator) {
        this.validator = validator;
    }

    protected abstract Optional<Endpoint> getEndpoint(SAML2MessageContext var1, StatusResponseType var2);

    protected abstract AbstractPac4jDecoder getDecoder(WebContext var1);

    protected abstract String getProfileUri();
}

