/*
 * Decompiled with CFR 0.152.
 */
package com.duosecurity;

import com.auth0.jwt.interfaces.DecodedJWT;
import com.duosecurity.DuoIdTokenValidator;
import com.duosecurity.TokenValidator;
import com.duosecurity.Utils;
import com.duosecurity.Validator;
import com.duosecurity.exception.DuoException;
import com.duosecurity.model.HealthCheckResponse;
import com.duosecurity.model.Token;
import com.duosecurity.model.TokenResponse;
import com.duosecurity.service.DuoConnector;

public class Client {
    private static final String OAUTH_V_1_HEALTH_CHECK_ENDPOINT = "/oauth/v1/health_check";
    private static final String OAUTH_V_1_AUTHORIZE_ENDPOINT = "/oauth/v1/authorize";
    private static final String OAUTH_V_1_TOKEN_ENDPOINT = "/oauth/v1/token";
    private static final String CLIENT_ASSERTION_TYPE = "urn:ietf:params:oauth:client-assertion-type:jwt-bearer";
    private static final String USER_AGENT_LIB = "duo_universal_java";
    private static final String USER_AGENT_VERSION = "1.2.0";
    private String clientId;
    private String clientSecret;
    private String apiHost;
    private String redirectUri;
    private Boolean useDuoCodeAttribute;
    private String proxyHost;
    private Integer proxyPort;
    protected DuoConnector duoConnector;
    private String userAgent;

    private Client() {
    }

    @Deprecated
    public Client(String clientId, String clientSecret, String apiHost, String redirectUri) throws DuoException {
        this(clientId, clientSecret, apiHost, redirectUri, null);
    }

    @Deprecated
    public Client(String clientId, String clientSecret, String apiHost, String redirectUri, String[] userCaCerts) throws DuoException {
        Client client = new Builder(clientId, clientSecret, apiHost, redirectUri).setCACerts(userCaCerts).build();
        this.clientId = client.clientId;
        this.clientSecret = client.clientSecret;
        this.apiHost = client.apiHost;
        this.redirectUri = client.redirectUri;
        this.useDuoCodeAttribute = client.useDuoCodeAttribute;
        this.duoConnector = client.duoConnector;
        this.userAgent = client.userAgent;
    }

    @Deprecated
    public Client(String clientId, String clientSecret, String apiHost, String redirectUri, String proxyHost, Integer proxyPort, String[] userCaCerts) throws DuoException {
        Client client = new Builder(clientId, clientSecret, proxyHost, proxyPort, apiHost, redirectUri).setCACerts(userCaCerts).build();
        this.clientId = client.clientId;
        this.clientSecret = client.clientSecret;
        this.apiHost = client.apiHost;
        this.redirectUri = client.redirectUri;
        this.useDuoCodeAttribute = client.useDuoCodeAttribute;
        this.duoConnector = client.duoConnector;
        this.userAgent = client.userAgent;
        this.proxyHost = client.proxyHost;
        this.proxyPort = client.proxyPort;
    }

    public HealthCheckResponse healthCheck() throws DuoException {
        String aud = Utils.getAndValidateUrl(this.apiHost, OAUTH_V_1_HEALTH_CHECK_ENDPOINT).toString();
        HealthCheckResponse response = this.duoConnector.duoHealthcheck(this.clientId, Utils.createJwt(this.clientId, this.clientSecret, aud));
        if (!response.wasSuccess().booleanValue()) {
            throw new DuoException(response.getMessage());
        }
        return response;
    }

    public String createAuthUrl(String username, String state) throws DuoException {
        Validator.validateUsername(username);
        Validator.validateState(state);
        String request = Utils.createJwtForAuthUrl(this.clientId, this.clientSecret, this.redirectUri, state, username, this.useDuoCodeAttribute);
        String query = String.format("?scope=openid&response_type=code&redirect_uri=%s&client_id=%s&request=%s", this.redirectUri, this.clientId, request);
        return Utils.getAndValidateUrl(this.apiHost, OAUTH_V_1_AUTHORIZE_ENDPOINT + query).toString();
    }

    public Token exchangeAuthorizationCodeFor2FAResult(String duoCode, String username) throws DuoException {
        DuoIdTokenValidator validator = new DuoIdTokenValidator(this.clientSecret, username, this.clientId, this.apiHost);
        return this.exchangeAuthorizationCodeFor2FAResult(duoCode, validator);
    }

    public Token exchangeAuthorizationCodeFor2FAResult(String duoCode, TokenValidator validator) throws DuoException {
        String aud = Utils.getAndValidateUrl(this.apiHost, OAUTH_V_1_TOKEN_ENDPOINT).toString();
        TokenResponse response = this.duoConnector.exchangeAuthorizationCodeFor2FAResult(this.userAgent, "authorization_code", duoCode, this.redirectUri, CLIENT_ASSERTION_TYPE, Utils.createJwt(this.clientId, this.clientSecret, aud));
        String idToken = response.getId_token();
        DecodedJWT decodedJwt = validator.validateAndDecode(idToken);
        return Utils.transformDecodedJwtToToken(decodedJwt);
    }

    public String generateState() {
        return Utils.generateJwtId(36);
    }

    public static class Builder {
        private final String clientId;
        private final String clientSecret;
        private final String apiHost;
        private String proxyHost;
        private Integer proxyPort;
        private final String redirectUri;
        private Boolean useDuoCodeAttribute;
        private String[] caCerts;
        private String userAgent;
        private static final String[] DEFAULT_CA_CERTS = new String[]{"sha256/I/Lt/z7ekCWanjD0Cvj5EqXls2lOaThEA0H2Bg4BT/o=", "sha256/r/mIkG3eEpVdm+u/ko/cwxzOMo1bk4TyHIlByibiA5E=", "sha256/WoiWRyIOVNa9ihaBciRSC7XHjliYS9VwUGOIud4PB18=", "sha256/dykHF2FLJfEpZOvbOLX4PKrcD2w2sHd/iA/G3uHTOcw=", "sha256/JZaQTcTWma4gws703OR/KFk313RkrDcHRvUt6na6DCg=", "sha256/++MBgDH5WGvL9Bcn5Be30cRcL0f5O+NyoXuWtQdX1aI=", "sha256/f0KW/FtqTjs108NpYj42SrGvOB2PpxIVM8nWxjPqJGE=", "sha256/NqvDJlas/GRcYbcWE8S/IceH9cq77kg0jVhZeAPXq8k=", "sha256/9+ze1cZgR9KO1kZrVDxA4HQ6voHRCSVNz4RdTCx4U8U=", "sha256/j9ESw8g3DxR9XM06fYZeuN1UB4O6xp/GAIjjdD/zM3g="};

        public Builder(String clientId, String clientSecret, String apiHost, String redirectUri) {
            this.clientId = clientId;
            this.clientSecret = clientSecret;
            this.apiHost = apiHost;
            this.redirectUri = redirectUri;
            this.caCerts = DEFAULT_CA_CERTS;
            this.useDuoCodeAttribute = true;
            this.userAgent = this.computeUserAgent();
        }

        public Builder(String clientId, String clientSecret, String proxyHost, Integer proxyPort, String apiHost, String redirectUri) {
            this.clientId = clientId;
            this.clientSecret = clientSecret;
            this.apiHost = apiHost;
            this.proxyHost = proxyHost;
            this.proxyPort = proxyPort;
            this.redirectUri = redirectUri;
            this.caCerts = DEFAULT_CA_CERTS;
            this.useDuoCodeAttribute = true;
            this.userAgent = this.computeUserAgent();
        }

        public Client build() throws DuoException {
            Validator.validateClientParams(this.clientId, this.clientSecret, this.apiHost, this.redirectUri);
            Client client = new Client();
            client.clientId = this.clientId;
            client.clientSecret = this.clientSecret;
            client.apiHost = this.apiHost;
            client.redirectUri = this.redirectUri;
            client.useDuoCodeAttribute = this.useDuoCodeAttribute;
            client.userAgent = this.userAgent;
            client.duoConnector = new DuoConnector(this.apiHost, this.proxyHost, this.proxyPort, this.caCerts);
            return client;
        }

        public Builder setCACerts(String[] userCaCerts) {
            if (Utils.validateCaCert(userCaCerts)) {
                this.caCerts = userCaCerts;
            }
            return this;
        }

        public Builder setUseDuoCodeAttribute(boolean useDuoCodeAttribute) {
            this.useDuoCodeAttribute = useDuoCodeAttribute;
            return this;
        }

        public Builder appendUserAgentInfo(String newUserAgent) {
            this.userAgent = String.format("%s %s", this.userAgent, newUserAgent);
            return this;
        }

        private String computeUserAgent() {
            String duoAgent = String.format("%s/%s", Client.USER_AGENT_LIB, Client.USER_AGENT_VERSION);
            String javaAgent = String.format("%s/%s", System.getProperty("java.vendor"), System.getProperty("java.version"));
            String osAgent = String.format("%s/%s/%s", System.getProperty("os.name"), System.getProperty("os.version"), System.getProperty("os.arch"));
            return String.format("%s %s %s", duoAgent, javaAgent, osAgent);
        }
    }
}

