/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.soap.wssecurity.impl;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.namespace.QName;
import net.shibboleth.shared.collection.CollectionSupport;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.util.AttributeMap;
import org.opensaml.core.xml.util.IndexedXMLObjectChildrenList;
import org.opensaml.soap.wssecurity.IdBearing;
import org.opensaml.soap.wssecurity.SecurityTokenReference;
import org.opensaml.soap.wssecurity.UsageBearing;
import org.opensaml.soap.wssecurity.impl.AbstractWSSecurityObject;

public class SecurityTokenReferenceImpl
extends AbstractWSSecurityObject
implements SecurityTokenReference {
    @Nullable
    private String id;
    @Nullable
    private List<String> usages;
    @Nonnull
    private final AttributeMap unknownAttributes = new AttributeMap((XMLObject)this);
    @Nonnull
    private final IndexedXMLObjectChildrenList<XMLObject> unknownChildren = new IndexedXMLObjectChildrenList((XMLObject)this);

    public SecurityTokenReferenceImpl(@Nullable String namespaceURI, @Nonnull String elementLocalName, @Nullable String namespacePrefix) {
        super(namespaceURI, elementLocalName, namespacePrefix);
    }

    @Nullable
    public List<String> getWSSEUsages() {
        return this.usages;
    }

    public void setWSSEUsages(@Nullable List<String> newUsages) {
        this.usages = (List)this.prepareForAssignment(this.usages, newUsages);
        this.manageQualifiedAttributeNamespace(UsageBearing.WSSE_USAGE_ATTR_NAME, this.usages != null && !this.usages.isEmpty());
    }

    @Nullable
    public String getWSUId() {
        return this.id;
    }

    public void setWSUId(@Nullable String newId) {
        String oldId = this.id;
        this.id = this.prepareForAssignment(this.id, newId);
        this.registerOwnID(oldId, this.id);
        this.manageQualifiedAttributeNamespace(IdBearing.WSU_ID_ATTR_NAME, this.id != null);
    }

    @Nonnull
    public AttributeMap getUnknownAttributes() {
        return this.unknownAttributes;
    }

    @Nonnull
    public List<XMLObject> getUnknownXMLObjects() {
        return this.unknownChildren;
    }

    @Nonnull
    public List<XMLObject> getUnknownXMLObjects(@Nonnull QName typeOrName) {
        return this.unknownChildren.subList(typeOrName);
    }

    @Override
    @Nullable
    public List<XMLObject> getOrderedChildren() {
        return CollectionSupport.copyToList(this.unknownChildren);
    }
}

