/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.throttle;

import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Stream;
import lombok.Generated;
import org.apache.commons.lang3.BooleanUtils;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.web.support.ThrottledSubmission;
import org.apereo.cas.web.support.ThrottledSubmissionsStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseMappableThrottledSubmissionsStore<T extends ThrottledSubmission>
implements ThrottledSubmissionsStore<T> {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(BaseMappableThrottledSubmissionsStore.class);
    private static final double SUBMISSION_RATE_DIVIDEND = 1000.0;
    protected final Map<String, T> backingMap;
    protected final CasConfigurationProperties casProperties;

    private static double submissionRate(ZonedDateTime a, ZonedDateTime b) {
        double rate = 1000.0 / (double)(a.toInstant().toEpochMilli() - b.toInstant().toEpochMilli());
        LOGGER.debug("Submission rate between [{}] and [{}] is [{}]", new Object[]{a, b, rate});
        return rate;
    }

    public void removeIf(Predicate<T> condition) {
        this.backingMap.entrySet().removeIf((? super E entry) -> condition.test((ThrottledSubmission)entry.getValue()));
    }

    public void remove(String key) {
        this.backingMap.remove(key);
    }

    public void put(T submission) {
        this.backingMap.put(submission.getKey(), submission);
    }

    public boolean contains(String key) {
        return this.backingMap.containsKey(key);
    }

    public T get(String key) {
        return (T)((ThrottledSubmission)this.backingMap.get(key));
    }

    public Stream<T> entries() {
        return this.backingMap.values().stream();
    }

    public boolean exceedsThreshold(String key, double thresholdRate) {
        T submissionEntry = this.get(key);
        LOGGER.debug("Last throttling date for key [{}] is [{}]", (Object)key, submissionEntry);
        if (submissionEntry != null) {
            ZonedDateTime now = ZonedDateTime.now(ZoneOffset.UTC);
            double submissionRate = BaseMappableThrottledSubmissionsStore.submissionRate(now, submissionEntry.getValue());
            boolean result = submissionRate > thresholdRate;
            LOGGER.debug("Current time is [{}] and submission date is [{}]. Submission rate between the dates is [{}] and your threshold rate [{}]. The submission rate is [{}] than the threshold rate, so the request [{}] be throttled.", new Object[]{now, submissionEntry.getValue(), submissionRate, thresholdRate, BooleanUtils.toString((boolean)result, (String)"greater", (String)"less"), BooleanUtils.toString((boolean)result, (String)"may", (String)"may not")});
            return result;
        }
        return false;
    }

    public void clear() {
        this.backingMap.clear();
    }

    public void release(double thresholdRate) {
        ZonedDateTime now = ZonedDateTime.now(ZoneOffset.UTC);
        LOGGER.debug("Attempting to release throttled records for now [{}]", (Object)now);
        this.removeIf(entry -> {
            if (entry.hasExpiredAlready()) {
                LOGGER.debug("Throttled submission [{}] has expired and will be removed", (Object)entry.getKey());
                return true;
            }
            if (entry.isStillInExpirationWindow()) {
                LOGGER.debug("Throttled submission [{}] has not expired and can only be released at [{}]", (Object)entry.getKey(), (Object)entry.getExpiration());
                return false;
            }
            double submissionRate = BaseMappableThrottledSubmissionsStore.submissionRate(now, entry.getValue());
            boolean result = submissionRate < thresholdRate;
            LOGGER.trace("Your threshold rate is [{}]. Submission rate between now [{}] and throttled entry [{}] @ [{}] is [{}]. This is [{}] than the threshold rate so the submission [{}] be released and removed from the store.", new Object[]{thresholdRate, now, entry.getId(), entry.getValue(), submissionRate, BooleanUtils.toString((boolean)result, (String)"less", (String)"greater"), BooleanUtils.toString((boolean)result, (String)"may", (String)"may not")});
            return result;
        });
    }

    @Generated
    public BaseMappableThrottledSubmissionsStore(Map<String, T> backingMap, CasConfigurationProperties casProperties) {
        this.backingMap = backingMap;
        this.casProperties = casProperties;
    }
}

