/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.common.engine.impl.db;

import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.api.FlowableWrongDbException;
import org.flowable.common.engine.impl.FlowableVersions;
import org.flowable.common.engine.impl.db.AbstractSqlScriptBasedDbSchemaManager;

public abstract class ServiceSqlScriptBasedDbSchemaManager
extends AbstractSqlScriptBasedDbSchemaManager {
    protected String table;
    protected String schemaComponent;
    protected String schemaVersionProperty;

    public ServiceSqlScriptBasedDbSchemaManager(String table, String schemaComponent, String schemaVersionProperty) {
        this.table = table;
        this.schemaComponent = schemaComponent;
        this.schemaVersionProperty = schemaVersionProperty;
    }

    @Override
    public void schemaCreate() {
        if (this.isUpdateNeeded()) {
            String dbVersion = this.getSchemaVersion();
            if (!"7.2.0.2".equals(dbVersion)) {
                throw new FlowableWrongDbException("7.2.0.2", dbVersion);
            }
        } else {
            this.internalDbSchemaCreate();
        }
    }

    protected void internalDbSchemaCreate() {
        this.executeMandatorySchemaResource("create", this.schemaComponent);
    }

    @Override
    public void schemaDrop() {
        try {
            this.executeMandatorySchemaResource("drop", this.schemaComponent);
        }
        catch (Exception e) {
            this.logger.info("Error dropping {} tables", (Object)this.schemaComponent, (Object)e);
        }
    }

    @Override
    public String schemaUpdate() {
        return this.schemaUpdate(null);
    }

    @Override
    public String schemaUpdate(String engineDbVersion) {
        String feedback = null;
        if (this.isUpdateNeeded()) {
            boolean isUpgradeNeeded;
            String dbVersion = this.getSchemaVersion();
            String compareWithVersion = null;
            compareWithVersion = dbVersion == null ? "6.1.2.0" : dbVersion;
            int matchingVersionIndex = FlowableVersions.getFlowableVersionIndexForDbVersion(compareWithVersion);
            boolean bl = isUpgradeNeeded = matchingVersionIndex != FlowableVersions.FLOWABLE_VERSIONS.size() - 1;
            if (isUpgradeNeeded) {
                this.dbSchemaUpgrade(this.schemaComponent, matchingVersionIndex, engineDbVersion);
            }
            feedback = "upgraded from " + compareWithVersion + " to 7.2.0.2";
        } else {
            this.schemaCreate();
        }
        return feedback;
    }

    @Override
    public void schemaCheckVersion() {
        String dbVersion = this.getSchemaVersion();
        if (!"7.2.0.2".equals(dbVersion)) {
            throw new FlowableWrongDbException("7.2.0.2", dbVersion);
        }
    }

    protected boolean isUpdateNeeded() {
        return this.isTablePresent(this.table);
    }

    protected String getSchemaVersion() {
        if (this.schemaVersionProperty == null) {
            throw new FlowableException("Schema version property is not set");
        }
        String dbVersion = this.getProperty(this.schemaVersionProperty);
        if (dbVersion == null) {
            return this.getUpgradeStartVersion();
        }
        return dbVersion;
    }

    protected String getUpgradeStartVersion() {
        return "6.1.2.0";
    }
}

