/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.common.engine.impl.tenant;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.flowable.common.engine.api.delegate.event.FlowableEvent;
import org.flowable.common.engine.api.delegate.event.FlowableEventDispatcher;
import org.flowable.common.engine.api.tenant.ChangeTenantIdResult;
import org.flowable.common.engine.impl.db.DbSqlSession;
import org.flowable.common.engine.impl.event.FlowableChangeTenantIdEventImpl;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.common.engine.impl.tenant.BaseChangeTenantIdCmd;
import org.flowable.common.engine.impl.tenant.ChangeTenantIdBuilderImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecuteChangeTenantIdCmd
extends BaseChangeTenantIdCmd {
    protected static final Logger LOGGER = LoggerFactory.getLogger(ExecuteChangeTenantIdCmd.class);
    protected final Set<String> entityTypes;
    protected final boolean dispatchEvent;

    public ExecuteChangeTenantIdCmd(ChangeTenantIdBuilderImpl builder, String engineScopeType, Set<String> entityTypes) {
        this(builder, engineScopeType, entityTypes, true);
    }

    public ExecuteChangeTenantIdCmd(ChangeTenantIdBuilderImpl builder, String engineScopeType, Set<String> entityTypes, boolean dispatchEvent) {
        super(builder, engineScopeType);
        this.entityTypes = entityTypes;
        this.dispatchEvent = dispatchEvent;
    }

    @Override
    protected Map<String, Long> executeOperation(DbSqlSession dbSqlSession, Map<String, Object> parameters) {
        if (LOGGER.isDebugEnabled()) {
            String definitionTenantId = this.builder.getDefinitionTenantId();
            Object option = definitionTenantId != null ? " but only for instances from the '" + definitionTenantId + "' tenant definitions" : "";
            LOGGER.debug("Executing instance migration from '{}' to '{}'{}.", new Object[]{parameters.get("sourceTenantId"), parameters.get("targetTenantId"), option});
        }
        HashMap<String, Long> results = new HashMap<String, Long>();
        for (String entityType : this.entityTypes) {
            results.put(entityType, Long.valueOf(dbSqlSession.directUpdate("changeTenantId" + entityType, parameters)));
        }
        return results;
    }

    @Override
    protected void beforeReturn(CommandContext commandContext, ChangeTenantIdResult result) {
        FlowableEventDispatcher eventDispatcher = this.getEngineConfiguration(commandContext).getEventDispatcher();
        if (this.dispatchEvent && eventDispatcher != null && eventDispatcher.isEnabled()) {
            String sourceTenantId = this.builder.getSourceTenantId();
            String targetTenantId = this.builder.getTargetTenantId();
            String definitionTenantId = this.builder.getDefinitionTenantId();
            eventDispatcher.dispatchEvent((FlowableEvent)new FlowableChangeTenantIdEventImpl(this.engineScopeType, sourceTenantId, targetTenantId, definitionTenantId), this.engineScopeType);
        }
    }
}

