/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.shaded.reactor.netty.udp;

import io.micrometer.shaded.io.netty.channel.Channel;
import io.micrometer.shaded.io.netty.channel.ChannelFactory;
import io.micrometer.shaded.io.netty.channel.ChannelOption;
import io.micrometer.shaded.io.netty.channel.EventLoopGroup;
import io.micrometer.shaded.io.netty.channel.socket.DatagramChannel;
import io.micrometer.shaded.io.netty.channel.socket.InternetProtocolFamily;
import io.micrometer.shaded.io.netty.channel.socket.nio.NioDatagramChannel;
import io.micrometer.shaded.io.netty.channel.unix.DomainDatagramChannel;
import io.micrometer.shaded.io.netty.handler.logging.LogLevel;
import io.micrometer.shaded.io.netty.handler.logging.LoggingHandler;
import io.micrometer.shaded.io.netty.resolver.AddressResolverGroup;
import io.micrometer.shaded.reactor.netty.channel.ChannelMetricsRecorder;
import io.micrometer.shaded.reactor.netty.channel.ChannelOperations;
import io.micrometer.shaded.reactor.netty.channel.MicrometerChannelMetricsRecorder;
import io.micrometer.shaded.reactor.netty.resources.ConnectionProvider;
import io.micrometer.shaded.reactor.netty.resources.LoopResources;
import io.micrometer.shaded.reactor.netty.transport.ClientTransportConfig;
import io.micrometer.shaded.reactor.netty.transport.logging.AdvancedByteBufFormat;
import io.micrometer.shaded.reactor.netty.udp.UdpClient;
import io.micrometer.shaded.reactor.netty.udp.UdpOperations;
import io.micrometer.shaded.reactor.netty.udp.UdpResources;
import io.micrometer.shaded.reactor.util.annotation.Nullable;
import java.net.SocketAddress;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.function.Supplier;

public final class UdpClientConfig
extends ClientTransportConfig<UdpClientConfig> {
    InternetProtocolFamily family;
    static final ChannelOperations.OnSetup DEFAULT_OPS = (ch, c, msg) -> new UdpOperations(ch, c);
    static final LoggingHandler LOGGING_HANDLER = AdvancedByteBufFormat.HEX_DUMP.toLoggingHandler(UdpClient.class.getName(), LogLevel.DEBUG, Charset.defaultCharset());

    @Override
    public final ChannelOperations.OnSetup channelOperationsProvider() {
        return DEFAULT_OPS;
    }

    @Nullable
    public final InternetProtocolFamily family() {
        return this.family;
    }

    UdpClientConfig(ConnectionProvider connectionProvider, Map<ChannelOption<?>, ?> options, Supplier<? extends SocketAddress> remoteAddress) {
        super(connectionProvider, options, remoteAddress);
    }

    UdpClientConfig(UdpClientConfig parent) {
        super(parent);
        this.family = parent.family;
    }

    @Override
    protected Class<? extends Channel> channelType(boolean isDomainSocket) {
        return isDomainSocket ? DomainDatagramChannel.class : DatagramChannel.class;
    }

    @Override
    protected ChannelFactory<? extends Channel> connectionFactory(EventLoopGroup elg, boolean isDomainSocket) {
        if (this.isPreferNative()) {
            return super.connectionFactory(elg, isDomainSocket);
        }
        return () -> new NioDatagramChannel(this.family());
    }

    @Override
    protected AddressResolverGroup<?> defaultAddressResolverGroup() {
        return UdpResources.get().getOrCreateDefaultResolver();
    }

    @Override
    protected LoggingHandler defaultLoggingHandler() {
        return LOGGING_HANDLER;
    }

    @Override
    protected LoopResources defaultLoopResources() {
        return UdpResources.get();
    }

    @Override
    protected ChannelMetricsRecorder defaultMetricsRecorder() {
        return MicrometerUdpClientMetricsRecorder.INSTANCE;
    }

    static final class MicrometerUdpClientMetricsRecorder
    extends MicrometerChannelMetricsRecorder {
        static final MicrometerUdpClientMetricsRecorder INSTANCE = new MicrometerUdpClientMetricsRecorder();

        MicrometerUdpClientMetricsRecorder() {
            super("io.micrometer.shaded.reactor.netty.udp.client", "udp");
        }
    }
}

