/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.jpa.entity.task;

import com.fasterxml.jackson.core.type.TypeReference;
import jakarta.persistence.Entity;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.Lob;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.PostLoad;
import jakarta.persistence.PostPersist;
import jakarta.persistence.PostUpdate;
import jakarta.persistence.PrePersist;
import jakarta.persistence.PreUpdate;
import jakarta.persistence.Table;
import jakarta.persistence.Transient;
import jakarta.validation.constraints.NotNull;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Pattern;
import org.apache.openjpa.enhance.PCRegistry;
import org.apache.openjpa.enhance.PersistenceCapable;
import org.apache.openjpa.enhance.StateManager;
import org.apache.syncope.common.lib.form.FormPropertyType;
import org.apache.syncope.core.persistence.api.entity.task.FormPropertyDef;
import org.apache.syncope.core.persistence.api.entity.task.MacroTask;
import org.apache.syncope.core.persistence.common.validation.FormPropertyDefCheck;
import org.apache.syncope.core.persistence.jpa.entity.AbstractGeneratedKeyEntity;
import org.apache.syncope.core.persistence.jpa.entity.task.JPAMacroTask;
import org.apache.syncope.core.provisioning.api.serialization.POJOHelper;

@Entity
@Table(name="FormPropertyDef")
@FormPropertyDefCheck
public class JPAFormPropertyDef
extends AbstractGeneratedKeyEntity
implements FormPropertyDef,
PersistenceCapable {
    private static final long serialVersionUID = -5839990371546587373L;
    public static final String TABLE = "FormPropertyDef";
    protected static final TypeReference<Map<String, String>> ENUMVALUES_TYPEREF = new TypeReference<Map<String, String>>(){};
    protected static final TypeReference<HashMap<Locale, String>> LABEL_TYPEREF = new TypeReference<HashMap<Locale, String>>(){};
    private int idx;
    @ManyToOne(optional=false)
    private JPAMacroTask macroTask;
    @NotNull
    private String name;
    @Lob
    private String labels;
    @Transient
    private Map<Locale, String> labelMap = new HashMap<Locale, String>();
    @NotNull
    @Enumerated(value=EnumType.STRING)
    private FormPropertyType type;
    @NotNull
    private Boolean readable = Boolean.TRUE;
    @NotNull
    private Boolean writable = Boolean.TRUE;
    @NotNull
    private Boolean required = Boolean.FALSE;
    private String stringRegEx;
    private String datePattern;
    @Lob
    private String enumValues;
    @NotNull
    private Boolean dropdownSingleSelection = Boolean.TRUE;
    @NotNull
    private Boolean dropdownFreeForm = Boolean.FALSE;
    private String mimeType;
    private static int pcInheritedFieldCount = AbstractGeneratedKeyEntity.pcGetManagedFieldCount();
    private static String[] pcFieldNames;
    private static Class[] pcFieldTypes;
    private static byte[] pcFieldFlags;
    private static Class pcPCSuperclass;

    public void setIdx(int idx) {
        JPAFormPropertyDef.pcSetidx(this, idx);
    }

    public JPAMacroTask getMacroTask() {
        return JPAFormPropertyDef.pcGetmacroTask(this);
    }

    public void setMacroTask(MacroTask macroTask) {
        this.checkType(macroTask, JPAMacroTask.class);
        JPAFormPropertyDef.pcSetmacroTask(this, (JPAMacroTask)macroTask);
    }

    public String getName() {
        return JPAFormPropertyDef.pcGetname(this);
    }

    public void setName(String name) {
        JPAFormPropertyDef.pcSetname(this, name);
    }

    public Optional<String> getLabel(Locale locale) {
        return Optional.ofNullable(this.labelMap.get(locale));
    }

    public Map<Locale, String> getLabels() {
        return this.labelMap;
    }

    public FormPropertyType getType() {
        return JPAFormPropertyDef.pcGettype(this);
    }

    public void setType(FormPropertyType type) {
        JPAFormPropertyDef.pcSettype(this, type);
    }

    public boolean isReadable() {
        return JPAFormPropertyDef.pcGetreadable(this) == null ? true : JPAFormPropertyDef.pcGetreadable(this);
    }

    public void setReadable(boolean readable) {
        JPAFormPropertyDef.pcSetreadable(this, readable);
    }

    public boolean isWritable() {
        return JPAFormPropertyDef.pcGetwritable(this) == null ? true : JPAFormPropertyDef.pcGetwritable(this);
    }

    public void setWritable(boolean writable) {
        JPAFormPropertyDef.pcSetwritable(this, writable);
    }

    public boolean isRequired() {
        return JPAFormPropertyDef.pcGetrequired(this) == null ? false : JPAFormPropertyDef.pcGetrequired(this);
    }

    public void setRequired(boolean required) {
        JPAFormPropertyDef.pcSetrequired(this, required);
    }

    public Pattern getStringRegEx() {
        return Optional.ofNullable(JPAFormPropertyDef.pcGetstringRegEx(this)).map(Pattern::compile).orElse(null);
    }

    public void setStringRegEx(Pattern stringRegEx) {
        JPAFormPropertyDef.pcSetstringRegEx(this, Optional.ofNullable(stringRegEx).map(Pattern::pattern).orElse(null));
    }

    public String getDatePattern() {
        return JPAFormPropertyDef.pcGetdatePattern(this);
    }

    public void setDatePattern(String datePattern) {
        JPAFormPropertyDef.pcSetdatePattern(this, datePattern);
    }

    public Map<String, String> getEnumValues() {
        return Optional.ofNullable(JPAFormPropertyDef.pcGetenumValues(this)).map(v -> (Map)POJOHelper.deserialize((String)v, ENUMVALUES_TYPEREF)).orElseGet(Map::of);
    }

    public void setEnumValues(Map<String, String> enumValues) {
        JPAFormPropertyDef.pcSetenumValues(this, Optional.ofNullable(enumValues).map(POJOHelper::serialize).orElse(null));
    }

    public boolean isDropdownSingleSelection() {
        return JPAFormPropertyDef.pcGetdropdownSingleSelection(this) == null ? false : JPAFormPropertyDef.pcGetdropdownSingleSelection(this);
    }

    public void setDropdownSingleSelection(boolean dropdownSingleSelection) {
        JPAFormPropertyDef.pcSetdropdownSingleSelection(this, dropdownSingleSelection);
    }

    public boolean isDropdownFreeForm() {
        return JPAFormPropertyDef.pcGetdropdownFreeForm(this) == null ? false : JPAFormPropertyDef.pcGetdropdownFreeForm(this);
    }

    public void setDropdownFreeForm(boolean dropdownFreeForm) {
        JPAFormPropertyDef.pcSetdropdownFreeForm(this, dropdownFreeForm);
    }

    public String getMimeType() {
        return JPAFormPropertyDef.pcGetmimeType(this);
    }

    public void setMimeType(String mimeType) {
        JPAFormPropertyDef.pcSetmimeType(this, mimeType);
    }

    protected void json2map(boolean clearFirst) {
        if (clearFirst) {
            this.getLabels().clear();
        }
        if (JPAFormPropertyDef.pcGetlabels(this) != null) {
            this.getLabels().putAll((Map)POJOHelper.deserialize((String)JPAFormPropertyDef.pcGetlabels(this), LABEL_TYPEREF));
        }
    }

    @PostLoad
    public void postLoad() {
        this.json2map(false);
    }

    @PostPersist
    @PostUpdate
    public void postSave() {
        this.json2map(true);
    }

    @PrePersist
    @PreUpdate
    public void map2json() {
        JPAFormPropertyDef.pcSetlabels(this, POJOHelper.serialize(this.getLabels()));
    }

    static {
        pcPCSuperclass = AbstractGeneratedKeyEntity.class;
        pcFieldNames = new String[]{"datePattern", "dropdownFreeForm", "dropdownSingleSelection", "enumValues", "idx", "labels", "macroTask", "mimeType", "name", "readable", "required", "stringRegEx", "type", "writable"};
        pcFieldTypes = new Class[]{String.class, Boolean.class, Boolean.class, String.class, Integer.TYPE, String.class, JPAMacroTask.class, String.class, String.class, Boolean.class, Boolean.class, String.class, FormPropertyType.class, Boolean.class};
        pcFieldFlags = new byte[]{26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26};
        PCRegistry.register(JPAFormPropertyDef.class, (String[])pcFieldNames, (Class[])pcFieldTypes, (byte[])pcFieldFlags, (Class)pcPCSuperclass, (String)"JPAFormPropertyDef", (PersistenceCapable)new JPAFormPropertyDef());
    }

    @Override
    public int pcGetEnhancementContractVersion() {
        return 255933283;
    }

    @Override
    protected void pcClearFields() {
        super.pcClearFields();
        this.datePattern = null;
        this.dropdownFreeForm = null;
        this.dropdownSingleSelection = null;
        this.enumValues = null;
        this.idx = 0;
        this.labels = null;
        this.macroTask = null;
        this.mimeType = null;
        this.name = null;
        this.readable = null;
        this.required = null;
        this.stringRegEx = null;
        this.type = null;
        this.writable = null;
    }

    @Override
    public PersistenceCapable pcNewInstance(StateManager stateManager, Object object, boolean bl) {
        JPAFormPropertyDef jPAFormPropertyDef = new JPAFormPropertyDef();
        if (bl) {
            jPAFormPropertyDef.pcClearFields();
        }
        jPAFormPropertyDef.pcStateManager = stateManager;
        jPAFormPropertyDef.pcCopyKeyFieldsFromObjectId(object);
        return jPAFormPropertyDef;
    }

    @Override
    public PersistenceCapable pcNewInstance(StateManager stateManager, boolean bl) {
        JPAFormPropertyDef jPAFormPropertyDef = new JPAFormPropertyDef();
        if (bl) {
            jPAFormPropertyDef.pcClearFields();
        }
        jPAFormPropertyDef.pcStateManager = stateManager;
        return jPAFormPropertyDef;
    }

    protected static int pcGetManagedFieldCount() {
        return 14 + AbstractGeneratedKeyEntity.pcGetManagedFieldCount();
    }

    @Override
    public void pcReplaceField(int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            super.pcReplaceField(n);
            return;
        }
        switch (n2) {
            case 0: {
                this.datePattern = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 1: {
                this.dropdownFreeForm = (Boolean)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 2: {
                this.dropdownSingleSelection = (Boolean)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 3: {
                this.enumValues = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 4: {
                this.idx = this.pcStateManager.replaceIntField((PersistenceCapable)this, n);
                return;
            }
            case 5: {
                this.labels = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 6: {
                this.macroTask = (JPAMacroTask)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 7: {
                this.mimeType = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 8: {
                this.name = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 9: {
                this.readable = (Boolean)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 10: {
                this.required = (Boolean)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 11: {
                this.stringRegEx = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 12: {
                this.type = (FormPropertyType)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 13: {
                this.writable = (Boolean)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void pcReplaceFields(int[] nArray) {
        for (int i = 0; i < nArray.length; ++i) {
            this.pcReplaceField(nArray[i]);
        }
    }

    @Override
    public void pcProvideField(int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            super.pcProvideField(n);
            return;
        }
        switch (n2) {
            case 0: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.datePattern);
                return;
            }
            case 1: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.dropdownFreeForm);
                return;
            }
            case 2: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.dropdownSingleSelection);
                return;
            }
            case 3: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.enumValues);
                return;
            }
            case 4: {
                this.pcStateManager.providedIntField((PersistenceCapable)this, n, this.idx);
                return;
            }
            case 5: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.labels);
                return;
            }
            case 6: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.macroTask);
                return;
            }
            case 7: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.mimeType);
                return;
            }
            case 8: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.name);
                return;
            }
            case 9: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.readable);
                return;
            }
            case 10: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.required);
                return;
            }
            case 11: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.stringRegEx);
                return;
            }
            case 12: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.type);
                return;
            }
            case 13: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.writable);
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void pcProvideFields(int[] nArray) {
        for (int i = 0; i < nArray.length; ++i) {
            this.pcProvideField(nArray[i]);
        }
    }

    protected void pcCopyField(JPAFormPropertyDef jPAFormPropertyDef, int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            super.pcCopyField(jPAFormPropertyDef, n);
            return;
        }
        switch (n2) {
            case 0: {
                this.datePattern = jPAFormPropertyDef.datePattern;
                return;
            }
            case 1: {
                this.dropdownFreeForm = jPAFormPropertyDef.dropdownFreeForm;
                return;
            }
            case 2: {
                this.dropdownSingleSelection = jPAFormPropertyDef.dropdownSingleSelection;
                return;
            }
            case 3: {
                this.enumValues = jPAFormPropertyDef.enumValues;
                return;
            }
            case 4: {
                this.idx = jPAFormPropertyDef.idx;
                return;
            }
            case 5: {
                this.labels = jPAFormPropertyDef.labels;
                return;
            }
            case 6: {
                this.macroTask = jPAFormPropertyDef.macroTask;
                return;
            }
            case 7: {
                this.mimeType = jPAFormPropertyDef.mimeType;
                return;
            }
            case 8: {
                this.name = jPAFormPropertyDef.name;
                return;
            }
            case 9: {
                this.readable = jPAFormPropertyDef.readable;
                return;
            }
            case 10: {
                this.required = jPAFormPropertyDef.required;
                return;
            }
            case 11: {
                this.stringRegEx = jPAFormPropertyDef.stringRegEx;
                return;
            }
            case 12: {
                this.type = jPAFormPropertyDef.type;
                return;
            }
            case 13: {
                this.writable = jPAFormPropertyDef.writable;
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void pcCopyFields(Object object, int[] nArray) {
        JPAFormPropertyDef jPAFormPropertyDef = (JPAFormPropertyDef)object;
        if (jPAFormPropertyDef.pcStateManager != this.pcStateManager) {
            throw new IllegalArgumentException();
        }
        if (this.pcStateManager == null) {
            throw new IllegalStateException();
        }
        for (int i = 0; i < nArray.length; ++i) {
            this.pcCopyField(jPAFormPropertyDef, nArray[i]);
        }
    }

    @Override
    public Class pcGetIDOwningClass() {
        return JPAFormPropertyDef.class;
    }

    private static final String pcGetdatePattern(JPAFormPropertyDef jPAFormPropertyDef) {
        if (jPAFormPropertyDef.pcStateManager == null) {
            return jPAFormPropertyDef.datePattern;
        }
        int n = pcInheritedFieldCount + 0;
        jPAFormPropertyDef.pcStateManager.accessingField(n);
        return jPAFormPropertyDef.datePattern;
    }

    private static final void pcSetdatePattern(JPAFormPropertyDef jPAFormPropertyDef, String string) {
        if (jPAFormPropertyDef.pcStateManager == null) {
            jPAFormPropertyDef.datePattern = string;
            return;
        }
        jPAFormPropertyDef.pcStateManager.settingStringField((PersistenceCapable)jPAFormPropertyDef, pcInheritedFieldCount + 0, jPAFormPropertyDef.datePattern, string, 0);
    }

    private static final Boolean pcGetdropdownFreeForm(JPAFormPropertyDef jPAFormPropertyDef) {
        if (jPAFormPropertyDef.pcStateManager == null) {
            return jPAFormPropertyDef.dropdownFreeForm;
        }
        int n = pcInheritedFieldCount + 1;
        jPAFormPropertyDef.pcStateManager.accessingField(n);
        return jPAFormPropertyDef.dropdownFreeForm;
    }

    private static final void pcSetdropdownFreeForm(JPAFormPropertyDef jPAFormPropertyDef, Boolean bl) {
        if (jPAFormPropertyDef.pcStateManager == null) {
            jPAFormPropertyDef.dropdownFreeForm = bl;
            return;
        }
        jPAFormPropertyDef.pcStateManager.settingObjectField((PersistenceCapable)jPAFormPropertyDef, pcInheritedFieldCount + 1, (Object)jPAFormPropertyDef.dropdownFreeForm, (Object)bl, 0);
    }

    private static final Boolean pcGetdropdownSingleSelection(JPAFormPropertyDef jPAFormPropertyDef) {
        if (jPAFormPropertyDef.pcStateManager == null) {
            return jPAFormPropertyDef.dropdownSingleSelection;
        }
        int n = pcInheritedFieldCount + 2;
        jPAFormPropertyDef.pcStateManager.accessingField(n);
        return jPAFormPropertyDef.dropdownSingleSelection;
    }

    private static final void pcSetdropdownSingleSelection(JPAFormPropertyDef jPAFormPropertyDef, Boolean bl) {
        if (jPAFormPropertyDef.pcStateManager == null) {
            jPAFormPropertyDef.dropdownSingleSelection = bl;
            return;
        }
        jPAFormPropertyDef.pcStateManager.settingObjectField((PersistenceCapable)jPAFormPropertyDef, pcInheritedFieldCount + 2, (Object)jPAFormPropertyDef.dropdownSingleSelection, (Object)bl, 0);
    }

    private static final String pcGetenumValues(JPAFormPropertyDef jPAFormPropertyDef) {
        if (jPAFormPropertyDef.pcStateManager == null) {
            return jPAFormPropertyDef.enumValues;
        }
        int n = pcInheritedFieldCount + 3;
        jPAFormPropertyDef.pcStateManager.accessingField(n);
        return jPAFormPropertyDef.enumValues;
    }

    private static final void pcSetenumValues(JPAFormPropertyDef jPAFormPropertyDef, String string) {
        if (jPAFormPropertyDef.pcStateManager == null) {
            jPAFormPropertyDef.enumValues = string;
            return;
        }
        jPAFormPropertyDef.pcStateManager.settingStringField((PersistenceCapable)jPAFormPropertyDef, pcInheritedFieldCount + 3, jPAFormPropertyDef.enumValues, string, 0);
    }

    private static final int pcGetidx(JPAFormPropertyDef jPAFormPropertyDef) {
        if (jPAFormPropertyDef.pcStateManager == null) {
            return jPAFormPropertyDef.idx;
        }
        int n = pcInheritedFieldCount + 4;
        jPAFormPropertyDef.pcStateManager.accessingField(n);
        return jPAFormPropertyDef.idx;
    }

    private static final void pcSetidx(JPAFormPropertyDef jPAFormPropertyDef, int n) {
        if (jPAFormPropertyDef.pcStateManager == null) {
            jPAFormPropertyDef.idx = n;
            return;
        }
        jPAFormPropertyDef.pcStateManager.settingIntField((PersistenceCapable)jPAFormPropertyDef, pcInheritedFieldCount + 4, jPAFormPropertyDef.idx, n, 0);
    }

    private static final String pcGetlabels(JPAFormPropertyDef jPAFormPropertyDef) {
        if (jPAFormPropertyDef.pcStateManager == null) {
            return jPAFormPropertyDef.labels;
        }
        int n = pcInheritedFieldCount + 5;
        jPAFormPropertyDef.pcStateManager.accessingField(n);
        return jPAFormPropertyDef.labels;
    }

    private static final void pcSetlabels(JPAFormPropertyDef jPAFormPropertyDef, String string) {
        if (jPAFormPropertyDef.pcStateManager == null) {
            jPAFormPropertyDef.labels = string;
            return;
        }
        jPAFormPropertyDef.pcStateManager.settingStringField((PersistenceCapable)jPAFormPropertyDef, pcInheritedFieldCount + 5, jPAFormPropertyDef.labels, string, 0);
    }

    private static final JPAMacroTask pcGetmacroTask(JPAFormPropertyDef jPAFormPropertyDef) {
        if (jPAFormPropertyDef.pcStateManager == null) {
            return jPAFormPropertyDef.macroTask;
        }
        int n = pcInheritedFieldCount + 6;
        jPAFormPropertyDef.pcStateManager.accessingField(n);
        return jPAFormPropertyDef.macroTask;
    }

    private static final void pcSetmacroTask(JPAFormPropertyDef jPAFormPropertyDef, JPAMacroTask jPAMacroTask) {
        if (jPAFormPropertyDef.pcStateManager == null) {
            jPAFormPropertyDef.macroTask = jPAMacroTask;
            return;
        }
        jPAFormPropertyDef.pcStateManager.settingObjectField((PersistenceCapable)jPAFormPropertyDef, pcInheritedFieldCount + 6, (Object)jPAFormPropertyDef.macroTask, (Object)jPAMacroTask, 0);
    }

    private static final String pcGetmimeType(JPAFormPropertyDef jPAFormPropertyDef) {
        if (jPAFormPropertyDef.pcStateManager == null) {
            return jPAFormPropertyDef.mimeType;
        }
        int n = pcInheritedFieldCount + 7;
        jPAFormPropertyDef.pcStateManager.accessingField(n);
        return jPAFormPropertyDef.mimeType;
    }

    private static final void pcSetmimeType(JPAFormPropertyDef jPAFormPropertyDef, String string) {
        if (jPAFormPropertyDef.pcStateManager == null) {
            jPAFormPropertyDef.mimeType = string;
            return;
        }
        jPAFormPropertyDef.pcStateManager.settingStringField((PersistenceCapable)jPAFormPropertyDef, pcInheritedFieldCount + 7, jPAFormPropertyDef.mimeType, string, 0);
    }

    private static final String pcGetname(JPAFormPropertyDef jPAFormPropertyDef) {
        if (jPAFormPropertyDef.pcStateManager == null) {
            return jPAFormPropertyDef.name;
        }
        int n = pcInheritedFieldCount + 8;
        jPAFormPropertyDef.pcStateManager.accessingField(n);
        return jPAFormPropertyDef.name;
    }

    private static final void pcSetname(JPAFormPropertyDef jPAFormPropertyDef, String string) {
        if (jPAFormPropertyDef.pcStateManager == null) {
            jPAFormPropertyDef.name = string;
            return;
        }
        jPAFormPropertyDef.pcStateManager.settingStringField((PersistenceCapable)jPAFormPropertyDef, pcInheritedFieldCount + 8, jPAFormPropertyDef.name, string, 0);
    }

    private static final Boolean pcGetreadable(JPAFormPropertyDef jPAFormPropertyDef) {
        if (jPAFormPropertyDef.pcStateManager == null) {
            return jPAFormPropertyDef.readable;
        }
        int n = pcInheritedFieldCount + 9;
        jPAFormPropertyDef.pcStateManager.accessingField(n);
        return jPAFormPropertyDef.readable;
    }

    private static final void pcSetreadable(JPAFormPropertyDef jPAFormPropertyDef, Boolean bl) {
        if (jPAFormPropertyDef.pcStateManager == null) {
            jPAFormPropertyDef.readable = bl;
            return;
        }
        jPAFormPropertyDef.pcStateManager.settingObjectField((PersistenceCapable)jPAFormPropertyDef, pcInheritedFieldCount + 9, (Object)jPAFormPropertyDef.readable, (Object)bl, 0);
    }

    private static final Boolean pcGetrequired(JPAFormPropertyDef jPAFormPropertyDef) {
        if (jPAFormPropertyDef.pcStateManager == null) {
            return jPAFormPropertyDef.required;
        }
        int n = pcInheritedFieldCount + 10;
        jPAFormPropertyDef.pcStateManager.accessingField(n);
        return jPAFormPropertyDef.required;
    }

    private static final void pcSetrequired(JPAFormPropertyDef jPAFormPropertyDef, Boolean bl) {
        if (jPAFormPropertyDef.pcStateManager == null) {
            jPAFormPropertyDef.required = bl;
            return;
        }
        jPAFormPropertyDef.pcStateManager.settingObjectField((PersistenceCapable)jPAFormPropertyDef, pcInheritedFieldCount + 10, (Object)jPAFormPropertyDef.required, (Object)bl, 0);
    }

    private static final String pcGetstringRegEx(JPAFormPropertyDef jPAFormPropertyDef) {
        if (jPAFormPropertyDef.pcStateManager == null) {
            return jPAFormPropertyDef.stringRegEx;
        }
        int n = pcInheritedFieldCount + 11;
        jPAFormPropertyDef.pcStateManager.accessingField(n);
        return jPAFormPropertyDef.stringRegEx;
    }

    private static final void pcSetstringRegEx(JPAFormPropertyDef jPAFormPropertyDef, String string) {
        if (jPAFormPropertyDef.pcStateManager == null) {
            jPAFormPropertyDef.stringRegEx = string;
            return;
        }
        jPAFormPropertyDef.pcStateManager.settingStringField((PersistenceCapable)jPAFormPropertyDef, pcInheritedFieldCount + 11, jPAFormPropertyDef.stringRegEx, string, 0);
    }

    private static final FormPropertyType pcGettype(JPAFormPropertyDef jPAFormPropertyDef) {
        if (jPAFormPropertyDef.pcStateManager == null) {
            return jPAFormPropertyDef.type;
        }
        int n = pcInheritedFieldCount + 12;
        jPAFormPropertyDef.pcStateManager.accessingField(n);
        return jPAFormPropertyDef.type;
    }

    private static final void pcSettype(JPAFormPropertyDef jPAFormPropertyDef, FormPropertyType formPropertyType) {
        if (jPAFormPropertyDef.pcStateManager == null) {
            jPAFormPropertyDef.type = formPropertyType;
            return;
        }
        jPAFormPropertyDef.pcStateManager.settingObjectField((PersistenceCapable)jPAFormPropertyDef, pcInheritedFieldCount + 12, (Object)jPAFormPropertyDef.type, (Object)formPropertyType, 0);
    }

    private static final Boolean pcGetwritable(JPAFormPropertyDef jPAFormPropertyDef) {
        if (jPAFormPropertyDef.pcStateManager == null) {
            return jPAFormPropertyDef.writable;
        }
        int n = pcInheritedFieldCount + 13;
        jPAFormPropertyDef.pcStateManager.accessingField(n);
        return jPAFormPropertyDef.writable;
    }

    private static final void pcSetwritable(JPAFormPropertyDef jPAFormPropertyDef, Boolean bl) {
        if (jPAFormPropertyDef.pcStateManager == null) {
            jPAFormPropertyDef.writable = bl;
            return;
        }
        jPAFormPropertyDef.pcStateManager.settingObjectField((PersistenceCapable)jPAFormPropertyDef, pcInheritedFieldCount + 13, (Object)jPAFormPropertyDef.writable, (Object)bl, 0);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        boolean bl = this.pcSerializing();
        objectOutputStream.defaultWriteObject();
        if (bl) {
            this.pcSetDetachedState(null);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.pcSetDetachedState(PersistenceCapable.DESERIALIZED);
        objectInputStream.defaultReadObject();
    }
}

