/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive;

import java.util.Arrays;
import org.ldaptive.AbstractFreezable;
import org.ldaptive.AbstractOperation;
import org.ldaptive.ConnectionFactory;
import org.ldaptive.ConnectionFactoryManager;
import org.ldaptive.LdapUtils;
import org.ldaptive.Request;
import org.ldaptive.Result;
import org.ldaptive.handler.ExceptionHandler;
import org.ldaptive.handler.IntermediateResponseHandler;
import org.ldaptive.handler.ReferralHandler;
import org.ldaptive.handler.RequestHandler;
import org.ldaptive.handler.ResponseControlHandler;
import org.ldaptive.handler.ResultHandler;
import org.ldaptive.handler.ResultPredicate;
import org.ldaptive.handler.UnsolicitedNotificationHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractOperationFactory<Q extends Request, S extends Result>
extends AbstractFreezable
implements ConnectionFactoryManager {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private ConnectionFactory factory;
    private RequestHandler<Q>[] requestHandlers;
    private ResultHandler[] resultHandlers;
    private ResponseControlHandler[] controlHandlers;
    private ReferralHandler[] referralHandlers;
    private IntermediateResponseHandler[] intermediateResponseHandlers;
    private ExceptionHandler exceptionHandler;
    private ResultPredicate throwCondition;
    private UnsolicitedNotificationHandler[] unsolicitedNotificationHandlers;

    @Override
    public void freeze() {
        super.freeze();
        AbstractOperationFactory.freeze(this.factory);
        AbstractOperationFactory.freeze(this.requestHandlers);
        AbstractOperationFactory.freeze(this.resultHandlers);
        AbstractOperationFactory.freeze(this.controlHandlers);
        AbstractOperationFactory.freeze(this.referralHandlers);
        AbstractOperationFactory.freeze(this.intermediateResponseHandlers);
        AbstractOperationFactory.freeze(this.exceptionHandler);
        AbstractOperationFactory.freeze(this.unsolicitedNotificationHandlers);
        AbstractOperationFactory.freeze(this.referralHandlers);
    }

    @Override
    public ConnectionFactory getConnectionFactory() {
        return this.factory;
    }

    @Override
    public void setConnectionFactory(ConnectionFactory cf) {
        this.assertMutable();
        this.factory = cf;
    }

    public RequestHandler<Q>[] getRequestHandlers() {
        return LdapUtils.copyArray(this.requestHandlers);
    }

    public void setRequestHandlers(RequestHandler<Q> ... handlers) {
        this.assertMutable();
        this.requestHandlers = LdapUtils.copyArray(handlers);
    }

    public ResultHandler[] getResultHandlers() {
        return LdapUtils.copyArray(this.resultHandlers);
    }

    public void setResultHandlers(ResultHandler ... handlers) {
        this.assertMutable();
        this.resultHandlers = LdapUtils.copyArray(handlers);
    }

    public ResponseControlHandler[] getControlHandlers() {
        return LdapUtils.copyArray(this.controlHandlers);
    }

    public void setControlHandlers(ResponseControlHandler ... handlers) {
        this.assertMutable();
        this.controlHandlers = LdapUtils.copyArray(handlers);
    }

    public ReferralHandler[] getReferralHandlers() {
        return LdapUtils.copyArray(this.referralHandlers);
    }

    public void setReferralHandlers(ReferralHandler ... handlers) {
        this.assertMutable();
        this.referralHandlers = LdapUtils.copyArray(handlers);
    }

    public IntermediateResponseHandler[] getIntermediateResponseHandlers() {
        return LdapUtils.copyArray(this.intermediateResponseHandlers);
    }

    public void setIntermediateResponseHandlers(IntermediateResponseHandler ... handlers) {
        this.assertMutable();
        this.intermediateResponseHandlers = LdapUtils.copyArray(handlers);
    }

    public ExceptionHandler getExceptionHandler() {
        return this.exceptionHandler;
    }

    public void setExceptionHandler(ExceptionHandler handler) {
        this.assertMutable();
        this.exceptionHandler = handler;
    }

    public ResultPredicate getThrowCondition() {
        return this.throwCondition;
    }

    public void setThrowCondition(ResultPredicate function) {
        this.assertMutable();
        this.throwCondition = function;
    }

    public UnsolicitedNotificationHandler[] getUnsolicitedNotificationHandlers() {
        return LdapUtils.copyArray(this.unsolicitedNotificationHandlers);
    }

    public void setUnsolicitedNotificationHandlers(UnsolicitedNotificationHandler ... handlers) {
        this.assertMutable();
        this.unsolicitedNotificationHandlers = LdapUtils.copyArray(handlers);
    }

    protected void initializeOperation(AbstractOperation<Q, S> op) {
        if (this.requestHandlers != null) {
            op.setRequestHandlers(this.requestHandlers);
        }
        if (this.resultHandlers != null) {
            op.setResultHandlers(this.resultHandlers);
        }
        if (this.controlHandlers != null) {
            op.setControlHandlers(this.controlHandlers);
        }
        if (this.referralHandlers != null) {
            op.setReferralHandlers(this.referralHandlers);
        }
        if (this.intermediateResponseHandlers != null) {
            op.setIntermediateResponseHandlers(this.intermediateResponseHandlers);
        }
        if (this.exceptionHandler != null) {
            op.setExceptionHandler(this.exceptionHandler);
        }
        if (this.throwCondition != null) {
            op.setThrowCondition(this.throwCondition);
        }
        if (this.unsolicitedNotificationHandlers != null) {
            op.setUnsolicitedNotificationHandlers(this.unsolicitedNotificationHandlers);
        }
    }

    public String toString() {
        return this.getClass().getName() + "@" + this.hashCode() + "::factory=" + this.factory + ", " + (String)(this.requestHandlers != null ? "requestHandlers=" + Arrays.toString(this.requestHandlers) + ", " : "") + (String)(this.resultHandlers != null ? "resultHandlers=" + Arrays.toString(this.resultHandlers) + ", " : "") + (String)(this.controlHandlers != null ? "controlHandlers=" + Arrays.toString(this.controlHandlers) + ", " : "") + (String)(this.referralHandlers != null ? "referralHandlers=" + Arrays.toString(this.referralHandlers) + ", " : "") + (String)(this.intermediateResponseHandlers != null ? "intermediateResponseHandlers=" + Arrays.toString(this.intermediateResponseHandlers) + ", " : "") + (String)(this.exceptionHandler != null ? "exceptionHandler=" + this.exceptionHandler + ", " : "") + (String)(this.throwCondition != null ? "throwCondition=" + this.throwCondition + ", " : "") + (String)(this.unsolicitedNotificationHandlers != null ? "unsolicitedNotificationHandlers=" + Arrays.toString(this.unsolicitedNotificationHandlers) + ", " : "");
    }
}

