/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.notifications.mail;

import jakarta.mail.internet.MimeMessage;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import javax.net.ssl.SSLSocketFactory;
import lombok.Generated;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.configuration.model.support.email.EmailProperties;
import org.apereo.cas.multitenancy.TenantCommunicationPolicy;
import org.apereo.cas.multitenancy.TenantDefinition;
import org.apereo.cas.multitenancy.TenantEmailCommunicationPolicy;
import org.apereo.cas.multitenancy.TenantExtractor;
import org.apereo.cas.notifications.mail.EmailCommunicationResult;
import org.apereo.cas.notifications.mail.EmailMessageRequest;
import org.apereo.cas.notifications.mail.EmailSender;
import org.apereo.cas.notifications.mail.EmailSenderCustomizer;
import org.apereo.cas.util.function.FunctionUtils;
import org.jooq.lambda.Unchecked;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.mail.MailProperties;
import org.springframework.boot.ssl.SslBundle;
import org.springframework.boot.ssl.SslBundles;
import org.springframework.context.ApplicationContext;
import org.springframework.context.MessageSource;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.mail.javamail.JavaMailSenderImpl;
import org.springframework.mail.javamail.MimeMessageHelper;

public class DefaultEmailSender
implements EmailSender {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultEmailSender.class);
    private final MessageSource messageSource;
    private final ApplicationContext applicationContext;
    private final List<EmailSenderCustomizer> emailSenderCustomizers;
    private final MailProperties mailProperties;
    private final ObjectProvider<SslBundles> sslBundles;
    private final TenantExtractor tenantExtractor;

    @Override
    public EmailCommunicationResult send(EmailMessageRequest emailRequest) throws Exception {
        JavaMailSenderImpl mailSender = this.createMailSender(emailRequest);
        boolean connectionAvailable = mailSender != null && (Boolean)FunctionUtils.doAndHandle(() -> {
            mailSender.testConnection();
            return true;
        }, throwable -> false).get() != false;
        List<String> recipients = emailRequest.getRecipients();
        if (connectionAvailable) {
            MimeMessage message = this.createEmailMessage(emailRequest, (JavaMailSender)mailSender);
            this.emailSenderCustomizers.forEach(customizer -> customizer.customize((JavaMailSender)mailSender, emailRequest));
            mailSender.send(message);
        }
        return ((EmailCommunicationResult.EmailCommunicationResultBuilder)((EmailCommunicationResult.EmailCommunicationResultBuilder)((EmailCommunicationResult.EmailCommunicationResultBuilder)EmailCommunicationResult.builder().success(connectionAvailable)).to(recipients)).body(emailRequest.getBody())).build();
    }

    protected MimeMessage createEmailMessage(EmailMessageRequest emailRequest, JavaMailSender mailSender) throws Exception {
        List<String> recipients = emailRequest.getRecipients();
        MimeMessage message = mailSender.createMimeMessage();
        MimeMessageHelper messageHelper = new MimeMessageHelper(message);
        messageHelper.setTo(recipients.toArray(ArrayUtils.EMPTY_STRING_ARRAY));
        EmailProperties emailProperties = emailRequest.getEmailProperties();
        messageHelper.setText(emailRequest.getBody(), emailProperties.isHtml());
        String subject = this.determineEmailSubject(emailRequest, this.messageSource);
        messageHelper.setSubject(subject);
        this.findTenantEmailCommunicationPolicy(emailRequest).filter(policy -> StringUtils.isNotBlank((CharSequence)policy.getFrom())).ifPresentOrElse(Unchecked.consumer(policy -> messageHelper.setFrom(policy.getFrom())), Unchecked.runnable(() -> messageHelper.setFrom(emailProperties.getFrom())));
        FunctionUtils.doIfNotBlank((CharSequence)emailProperties.getReplyTo(), arg_0 -> ((MimeMessageHelper)messageHelper).setReplyTo(arg_0));
        messageHelper.setValidateAddresses(emailProperties.isValidateAddresses());
        messageHelper.setPriority(emailProperties.getPriority());
        messageHelper.setCc(emailProperties.getCc().toArray(ArrayUtils.EMPTY_STRING_ARRAY));
        messageHelper.setBcc(emailProperties.getBcc().toArray(ArrayUtils.EMPTY_STRING_ARRAY));
        return message;
    }

    protected JavaMailSenderImpl createMailSender(EmailMessageRequest emailRequest) {
        JavaMailSenderImpl sender = this.applyProperties(new JavaMailSenderImpl(), emailRequest);
        return StringUtils.isNotBlank((CharSequence)sender.getHost()) ? sender : null;
    }

    protected JavaMailSenderImpl applyProperties(JavaMailSenderImpl sender, EmailMessageRequest emailRequest) {
        this.applyEmailServerProperties(sender, emailRequest);
        Properties javaMailProperties = DefaultEmailSender.asProperties(this.mailProperties.getProperties());
        String protocol = (String)StringUtils.defaultIfBlank((CharSequence)this.mailProperties.getProtocol(), (CharSequence)"smtp");
        MailProperties.Ssl ssl = this.mailProperties.getSsl();
        if (ssl.isEnabled()) {
            javaMailProperties.setProperty("mail." + protocol + ".ssl.enable", "true");
        }
        if (StringUtils.isNotBlank((CharSequence)ssl.getBundle())) {
            SslBundle sslBundle = ((SslBundles)this.sslBundles.getObject()).getBundle(ssl.getBundle());
            SSLSocketFactory socketFactory = sslBundle.createSslContext().getSocketFactory();
            javaMailProperties.put("mail." + protocol + ".ssl.socketFactory", socketFactory);
        }
        if (!javaMailProperties.isEmpty()) {
            sender.setJavaMailProperties(javaMailProperties);
        }
        return sender;
    }

    protected void applyEmailServerProperties(JavaMailSenderImpl sender, EmailMessageRequest emailMessageRequest) {
        Optional<TenantEmailCommunicationPolicy> tenantEmailCommunicationPolicy = this.findTenantEmailCommunicationPolicy(emailMessageRequest);
        tenantEmailCommunicationPolicy.ifPresentOrElse(policy -> {
            sender.setHost(policy.getHost());
            if (policy.getPort() > 0) {
                sender.setPort(policy.getPort());
            }
            sender.setUsername(policy.getUsername());
            sender.setPassword(policy.getPassword());
        }, () -> {
            sender.setHost(this.mailProperties.getHost());
            if (this.mailProperties.getPort() != null) {
                sender.setPort(this.mailProperties.getPort().intValue());
            }
            sender.setUsername(this.mailProperties.getUsername());
            sender.setPassword(this.mailProperties.getPassword());
        });
        sender.setProtocol(this.mailProperties.getProtocol());
        sender.setDefaultEncoding(this.mailProperties.getDefaultEncoding().name());
    }

    private Optional<TenantEmailCommunicationPolicy> findTenantEmailCommunicationPolicy(EmailMessageRequest emailMessageRequest) {
        return this.tenantExtractor.getTenantsManager().findTenant(emailMessageRequest.getTenant()).map(TenantDefinition::getCommunicationPolicy).filter(Objects::nonNull).map(TenantCommunicationPolicy::getEmailCommunicationPolicy).filter(Objects::nonNull).stream().findFirst();
    }

    private static Properties asProperties(Map<String, String> source) {
        Properties properties = new Properties();
        properties.putAll(source);
        return properties;
    }

    @Generated
    public DefaultEmailSender(MessageSource messageSource, ApplicationContext applicationContext, List<EmailSenderCustomizer> emailSenderCustomizers, MailProperties mailProperties, ObjectProvider<SslBundles> sslBundles, TenantExtractor tenantExtractor) {
        this.messageSource = messageSource;
        this.applicationContext = applicationContext;
        this.emailSenderCustomizers = emailSenderCustomizers;
        this.mailProperties = mailProperties;
        this.sslBundles = sslBundles;
        this.tenantExtractor = tenantExtractor;
    }

    @Generated
    public MessageSource getMessageSource() {
        return this.messageSource;
    }

    @Generated
    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    @Generated
    public List<EmailSenderCustomizer> getEmailSenderCustomizers() {
        return this.emailSenderCustomizers;
    }

    @Generated
    public MailProperties getMailProperties() {
        return this.mailProperties;
    }

    @Generated
    public ObjectProvider<SslBundles> getSslBundles() {
        return this.sslBundles;
    }

    @Generated
    public TenantExtractor getTenantExtractor() {
        return this.tenantExtractor;
    }
}

