/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web;

import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.authentication.principal.WebApplicationService;
import org.apereo.cas.configuration.model.support.captcha.GoogleRecaptchaProperties;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.RegisteredServiceProperty;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.util.RegexUtils;
import org.apereo.cas.util.spring.SpringExpressionLanguageValueResolver;
import org.apereo.cas.web.CaptchaActivationStrategy;
import org.apereo.cas.web.support.WebUtils;
import org.apereo.inspektr.common.web.ClientInfo;
import org.apereo.inspektr.common.web.ClientInfoHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.webflow.execution.RequestContext;

public class DefaultCaptchaActivationStrategy
implements CaptchaActivationStrategy {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultCaptchaActivationStrategy.class);
    private final ServicesManager servicesManager;

    private static Optional<GoogleRecaptchaProperties> evaluateResult(boolean result, GoogleRecaptchaProperties properties) {
        return result ? Optional.of(properties) : Optional.empty();
    }

    @Override
    public Optional<GoogleRecaptchaProperties> shouldActivate(RequestContext requestContext, GoogleRecaptchaProperties properties) {
        WebApplicationService service = WebUtils.getService((RequestContext)requestContext);
        RegisteredService registeredService = this.servicesManager.findServiceBy((Service)service);
        if (RegisteredServiceProperty.RegisteredServiceProperties.CAPTCHA_ENABLED.isAssignedTo(registeredService)) {
            LOGGER.trace("Checking for activation of captcha defined for service [{}]", (Object)registeredService);
            if (RegisteredServiceProperty.RegisteredServiceProperties.CAPTCHA_IP_ADDRESS_PATTERN.isAssignedTo(registeredService)) {
                String ip = Optional.ofNullable(ClientInfoHolder.getClientInfo()).map(ClientInfo::getClientIpAddress).orElse("").trim();
                LOGGER.trace("Checking for activation of captcha defined for service [{}] based on IP address [{}]", (Object)registeredService, (Object)ip);
                Set ipPattern = (Set)RegisteredServiceProperty.RegisteredServiceProperties.CAPTCHA_IP_ADDRESS_PATTERN.getPropertyValues(registeredService, Set.class);
                boolean result = Objects.requireNonNull(ipPattern).stream().anyMatch(pattern -> RegexUtils.find((String)pattern.toString().trim(), (String)ip));
                return DefaultCaptchaActivationStrategy.evaluateResult(result, properties);
            }
            boolean result = RegisteredServiceProperty.RegisteredServiceProperties.CAPTCHA_ENABLED.getPropertyBooleanValue(registeredService);
            return DefaultCaptchaActivationStrategy.evaluateResult(result, properties);
        }
        if (StringUtils.isNotBlank((CharSequence)properties.getActivateForIpAddressPattern())) {
            String ip = Optional.ofNullable(ClientInfoHolder.getClientInfo()).map(ClientInfo::getClientIpAddress).orElse("");
            LOGGER.debug("Remote IP address [{}] will be checked against [{}]", (Object)ip, (Object)properties.getActivateForIpAddressPattern());
            boolean activate = RegexUtils.find((String)properties.getActivateForIpAddressPattern(), (String)ip);
            return DefaultCaptchaActivationStrategy.evaluateResult(activate, properties);
        }
        String siteKey = SpringExpressionLanguageValueResolver.getInstance().resolve(properties.getSiteKey());
        LOGGER.trace("Checking for activation of captcha defined under site key [{}]", (Object)siteKey);
        return DefaultCaptchaActivationStrategy.evaluateResult(properties.isEnabled(), properties);
    }

    @Generated
    public DefaultCaptchaActivationStrategy(ServicesManager servicesManager) {
        this.servicesManager = servicesManager;
    }
}

