/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.util.List;
import org.apache.kafka.common.serialization.Serializer;
import org.apache.kafka.common.utils.Bytes;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.processor.ProcessorContext;
import org.apache.kafka.streams.processor.StateStore;
import org.apache.kafka.streams.processor.StateStoreContext;
import org.apache.kafka.streams.processor.internals.InternalProcessorContext;
import org.apache.kafka.streams.processor.internals.ProcessorContextUtils;
import org.apache.kafka.streams.state.KeyValueIterator;
import org.apache.kafka.streams.state.KeyValueStore;
import org.apache.kafka.streams.state.internals.MemoryLRUCache;
import org.apache.kafka.streams.state.internals.WrappedStateStore;

public class ChangeLoggingKeyValueBytesStore
extends WrappedStateStore<KeyValueStore<Bytes, byte[]>, byte[], byte[]>
implements KeyValueStore<Bytes, byte[]> {
    InternalProcessorContext context;

    ChangeLoggingKeyValueBytesStore(KeyValueStore<Bytes, byte[]> inner) {
        super(inner);
    }

    @Override
    @Deprecated
    public void init(ProcessorContext context, StateStore root) {
        this.context = ProcessorContextUtils.asInternalProcessorContext(context);
        super.init(context, root);
        this.maybeSetEvictionListener();
    }

    @Override
    public void init(StateStoreContext context, StateStore root) {
        this.context = ProcessorContextUtils.asInternalProcessorContext(context);
        super.init(context, root);
        this.maybeSetEvictionListener();
    }

    private void maybeSetEvictionListener() {
        if (this.wrapped() instanceof MemoryLRUCache) {
            ((MemoryLRUCache)this.wrapped()).setWhenEldestRemoved((key, value) -> this.log(key, null, this.context.timestamp()));
        }
    }

    @Override
    public long approximateNumEntries() {
        return ((KeyValueStore)this.wrapped()).approximateNumEntries();
    }

    @Override
    public void put(Bytes key, byte[] value) {
        ((KeyValueStore)this.wrapped()).put(key, value);
        this.log(key, value, this.context.timestamp());
    }

    @Override
    public byte[] putIfAbsent(Bytes key, byte[] value) {
        byte[] previous = ((KeyValueStore)this.wrapped()).putIfAbsent(key, value);
        if (previous == null) {
            this.log(key, value, this.context.timestamp());
        }
        return previous;
    }

    @Override
    public void putAll(List<KeyValue<Bytes, byte[]>> entries) {
        ((KeyValueStore)this.wrapped()).putAll(entries);
        for (KeyValue entry : entries) {
            this.log((Bytes)entry.key, (byte[])entry.value, this.context.timestamp());
        }
    }

    @Override
    public <PS extends Serializer<P>, P> KeyValueIterator<Bytes, byte[]> prefixScan(P prefix, PS prefixKeySerializer) {
        return ((KeyValueStore)this.wrapped()).prefixScan(prefix, prefixKeySerializer);
    }

    @Override
    public byte[] delete(Bytes key) {
        byte[] oldValue = (byte[])((KeyValueStore)this.wrapped()).delete(key);
        this.log(key, null, this.context.timestamp());
        return oldValue;
    }

    @Override
    public byte[] get(Bytes key) {
        return (byte[])((KeyValueStore)this.wrapped()).get(key);
    }

    @Override
    public KeyValueIterator<Bytes, byte[]> range(Bytes from, Bytes to) {
        return ((KeyValueStore)this.wrapped()).range(from, to);
    }

    @Override
    public KeyValueIterator<Bytes, byte[]> reverseRange(Bytes from, Bytes to) {
        return ((KeyValueStore)this.wrapped()).reverseRange(from, to);
    }

    @Override
    public KeyValueIterator<Bytes, byte[]> all() {
        return ((KeyValueStore)this.wrapped()).all();
    }

    @Override
    public KeyValueIterator<Bytes, byte[]> reverseAll() {
        return ((KeyValueStore)this.wrapped()).reverseAll();
    }

    void log(Bytes key, byte[] value, long timestamp) {
        this.context.logChange(this.name(), key, value, timestamp, ((KeyValueStore)this.wrapped()).getPosition());
    }
}

