/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.java.data;

import java.util.Iterator;
import org.apache.syncope.common.lib.SyncopeClientException;
import org.apache.syncope.common.lib.to.DynRealmTO;
import org.apache.syncope.common.lib.types.ClientExceptionType;
import org.apache.syncope.core.persistence.api.dao.AnyTypeDAO;
import org.apache.syncope.core.persistence.api.dao.DynRealmDAO;
import org.apache.syncope.core.persistence.api.dao.search.SearchCond;
import org.apache.syncope.core.persistence.api.entity.AnyType;
import org.apache.syncope.core.persistence.api.entity.DynRealm;
import org.apache.syncope.core.persistence.api.entity.DynRealmMembership;
import org.apache.syncope.core.persistence.api.entity.Entity;
import org.apache.syncope.core.persistence.api.entity.EntityFactory;
import org.apache.syncope.core.persistence.api.search.SearchCondConverter;
import org.apache.syncope.core.persistence.api.search.SearchCondVisitor;
import org.apache.syncope.core.provisioning.api.data.DynRealmDataBinder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DynRealmDataBinderImpl
implements DynRealmDataBinder {
    protected static final Logger LOG = LoggerFactory.getLogger(DynRealmDataBinder.class);
    protected final AnyTypeDAO anyTypeDAO;
    protected final DynRealmDAO dynRealmDAO;
    protected final EntityFactory entityFactory;
    protected final SearchCondVisitor searchCondVisitor;

    public DynRealmDataBinderImpl(AnyTypeDAO anyTypeDAO, DynRealmDAO dynRealmDAO, EntityFactory entityFactory, SearchCondVisitor searchCondVisitor) {
        this.anyTypeDAO = anyTypeDAO;
        this.dynRealmDAO = dynRealmDAO;
        this.entityFactory = entityFactory;
        this.searchCondVisitor = searchCondVisitor;
    }

    protected void setDynMembership(DynRealm dynRealm, AnyType anyType, String dynMembershipFIQL) {
        DynRealmMembership dynMembership;
        SearchCond dynMembershipCond = SearchCondConverter.convert((SearchCondVisitor)this.searchCondVisitor, (String)dynMembershipFIQL, (String[])new String[0]);
        if (!dynMembershipCond.isValid()) {
            SyncopeClientException sce = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.InvalidSearchParameters);
            sce.getElements().add(dynMembershipFIQL);
            throw sce;
        }
        if (dynRealm.getDynMembership(anyType).isPresent()) {
            dynMembership = (DynRealmMembership)dynRealm.getDynMembership(anyType).get();
        } else {
            dynMembership = (DynRealmMembership)this.entityFactory.newEntity(DynRealmMembership.class);
            dynMembership.setDynRealm(dynRealm);
            dynMembership.setAnyType(anyType);
            dynRealm.add(dynMembership);
        }
        dynMembership.setFIQLCond(dynMembershipFIQL);
    }

    public DynRealm create(DynRealmTO dynRealmTO) {
        return this.update((DynRealm)this.entityFactory.newEntity(DynRealm.class), dynRealmTO);
    }

    public DynRealm update(DynRealm toBeUpdated, DynRealmTO dynRealmTO) {
        toBeUpdated.setKey(dynRealmTO.getKey());
        DynRealm dynRealm = (DynRealm)this.dynRealmDAO.save((Entity)toBeUpdated);
        Iterator itor = dynRealm.getDynMemberships().iterator();
        while (itor.hasNext()) {
            DynRealmMembership memb = (DynRealmMembership)itor.next();
            memb.setDynRealm(null);
            itor.remove();
        }
        dynRealmTO.getDynMembershipConds().forEach((type, fiql) -> this.anyTypeDAO.findById(type).ifPresentOrElse(anyType -> this.setDynMembership(dynRealm, (AnyType)anyType, (String)fiql), () -> LOG.warn("Ignoring invalid {}: {}", (Object)AnyType.class.getSimpleName(), type)));
        return this.dynRealmDAO.saveAndRefreshDynMemberships(dynRealm);
    }

    public DynRealmTO getDynRealmTO(DynRealm dynRealm) {
        DynRealmTO dynRealmTO = new DynRealmTO();
        dynRealmTO.setKey(dynRealm.getKey());
        dynRealm.getDynMemberships().forEach(memb -> dynRealmTO.getDynMembershipConds().put(memb.getAnyType().getKey(), memb.getFIQLCond()));
        return dynRealmTO;
    }
}

