/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.flow.login;

import jakarta.servlet.http.HttpServletRequest;
import java.net.URI;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.AuthenticationHandlerExecutionResult;
import org.apereo.cas.authentication.AuthenticationResult;
import org.apereo.cas.authentication.AuthenticationResultBuilder;
import org.apereo.cas.authentication.MessageDescriptor;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.authentication.principal.WebApplicationService;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.ticket.AuthenticationAwareTicket;
import org.apereo.cas.ticket.Ticket;
import org.apereo.cas.util.function.FunctionUtils;
import org.apereo.cas.web.flow.actions.BaseCasWebflowAction;
import org.apereo.cas.web.flow.resolver.impl.CasWebflowEventResolutionConfigurationContext;
import org.apereo.cas.web.support.WebUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.binding.message.MessageBuilder;
import org.springframework.binding.message.MessageContext;
import org.springframework.webflow.action.EventFactorySupport;
import org.springframework.webflow.core.collection.AttributeMap;
import org.springframework.webflow.core.collection.LocalAttributeMap;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public class CreateTicketGrantingTicketAction
extends BaseCasWebflowAction {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(CreateTicketGrantingTicketAction.class);
    private final CasWebflowEventResolutionConfigurationContext configurationContext;

    protected Event doExecuteInternal(RequestContext context) {
        WebApplicationService service = WebUtils.getService((RequestContext)context);
        RegisteredService registeredService = WebUtils.getRegisteredService((RequestContext)context);
        AuthenticationResultBuilder authenticationResultBuilder = WebUtils.getAuthenticationResultBuilder((RequestContext)context);
        LOGGER.trace("Finalizing authentication transactions and issuing ticket-granting ticket");
        AuthenticationResult authenticationResult = (AuthenticationResult)FunctionUtils.doUnchecked(() -> this.configurationContext.getAuthenticationSystemSupport().finalizeAllAuthenticationTransactions(authenticationResultBuilder, (Service)service));
        LOGGER.trace("Finalizing authentication event...");
        Authentication authentication = this.buildFinalAuthentication(authenticationResult);
        String ticketGrantingTicket = this.determineTicketGrantingTicketId(context);
        LOGGER.debug("Creating ticket-granting ticket, potentially based on [{}]", (Object)ticketGrantingTicket);
        Ticket tgt = this.configurationContext.getSingleSignOnBuildingStrategy().buildTicketGrantingTicket(authenticationResult, authentication, ticketGrantingTicket);
        if (registeredService != null && registeredService.getAccessStrategy() != null) {
            WebUtils.putUnauthorizedRedirectUrlIntoFlowScope((RequestContext)context, (URI)registeredService.getAccessStrategy().getUnauthorizedRedirectUrl());
        }
        WebUtils.putTicketGrantingTicketInScopes((RequestContext)context, (Ticket)tgt);
        WebUtils.putAuthenticationResult((AuthenticationResult)authenticationResult, (RequestContext)context);
        WebUtils.putAuthentication((Ticket)tgt, (RequestContext)context);
        LOGGER.trace("Calculating authentication warning messages...");
        Collection<? extends MessageDescriptor> warnings = CreateTicketGrantingTicketAction.calculateAuthenticationWarningMessages(context);
        if (!warnings.isEmpty()) {
            LocalAttributeMap attributes = new LocalAttributeMap("authenticationWarnings", warnings);
            return new EventFactorySupport().event((Object)this, "successWithWarnings", (AttributeMap)attributes);
        }
        return this.success();
    }

    protected Authentication buildFinalAuthentication(AuthenticationResult authenticationResult) {
        return authenticationResult.getAuthentication();
    }

    protected String determineTicketGrantingTicketId(RequestContext context) {
        HttpServletRequest request = WebUtils.getHttpServletRequestFromExternalWebflowContext((RequestContext)context);
        String ticketGrantingTicketId = this.configurationContext.getTicketGrantingTicketCookieGenerator().retrieveCookieValue(request);
        if (StringUtils.isBlank((CharSequence)ticketGrantingTicketId)) {
            return WebUtils.getTicketGrantingTicketId((RequestContext)context);
        }
        return ticketGrantingTicketId;
    }

    private static Collection<? extends MessageDescriptor> calculateAuthenticationWarningMessages(RequestContext context) {
        Ticket ticketGrantingTicket = WebUtils.getTicketGrantingTicket((RequestContext)context);
        return Optional.ofNullable(ticketGrantingTicket).filter(AuthenticationAwareTicket.class::isInstance).map(AuthenticationAwareTicket.class::cast).map(tgt -> {
            Authentication authentication = tgt.getAuthentication();
            Set messages = authentication.getSuccesses().entrySet();
            List warnings = messages.stream().map(entry -> ((AuthenticationHandlerExecutionResult)entry.getValue()).getWarnings()).filter(entry -> !entry.isEmpty()).collect(Collectors.toList());
            warnings.add(authentication.getWarnings());
            return warnings.stream().flatMap(Collection::stream).peek(message -> CreateTicketGrantingTicketAction.addMessageDescriptorToMessageContext(context.getMessageContext(), message)).collect(Collectors.toSet());
        }).orElseGet(HashSet::new);
    }

    protected static void addMessageDescriptorToMessageContext(MessageContext context, MessageDescriptor warning) {
        MessageBuilder builder = new MessageBuilder().warning().code(warning.getCode()).defaultText(warning.getDefaultMessage()).args((Object[])warning.getParams());
        context.addMessage(builder.build());
    }

    @Generated
    public CreateTicketGrantingTicketAction(CasWebflowEventResolutionConfigurationContext configurationContext) {
        this.configurationContext = configurationContext;
    }
}

