/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.config;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.List;
import java.util.function.Supplier;
import org.springframework.beans.factory.annotation.AnnotatedBeanDefinition;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.parsing.ComponentDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.core.ResolvableType;
import org.springframework.core.annotation.MergedAnnotations;
import org.springframework.integration.annotation.InboundChannelAdapter;
import org.springframework.integration.annotation.Poller;
import org.springframework.integration.config.AbstractMethodAnnotationPostProcessor;
import org.springframework.integration.config.SourcePollingChannelAdapterFactoryBean;
import org.springframework.integration.core.MessageSource;
import org.springframework.integration.endpoint.MethodInvokingMessageSource;
import org.springframework.integration.endpoint.SourcePollingChannelAdapter;
import org.springframework.integration.util.ClassUtils;
import org.springframework.integration.util.MessagingAnnotationUtils;
import org.springframework.lang.Nullable;
import org.springframework.messaging.MessageHandler;
import org.springframework.util.Assert;

public class InboundChannelAdapterAnnotationPostProcessor
extends AbstractMethodAnnotationPostProcessor<InboundChannelAdapter> {
    @Override
    public String getInputChannelAttribute() {
        return "value";
    }

    @Override
    protected BeanDefinition resolveHandlerBeanDefinition(String beanName, AnnotatedBeanDefinition beanDefinition, ResolvableType handlerBeanType, List<Annotation> annotationChain) {
        Class handlerBeanClass = handlerBeanType.toClass();
        if (MessageSource.class.isAssignableFrom(handlerBeanClass)) {
            return beanDefinition;
        }
        Method method = null;
        if (Supplier.class.isAssignableFrom(handlerBeanClass)) {
            method = ClassUtils.SUPPLIER_GET_METHOD;
        } else if (ClassUtils.isKotlinFunction0(handlerBeanClass)) {
            method = ClassUtils.KOTLIN_FUNCTION_0_INVOKE_METHOD;
        }
        if (method != null) {
            return BeanDefinitionBuilder.genericBeanDefinition(MethodInvokingMessageSource.class).addPropertyReference("object", beanName).addPropertyValue("method", (Object)method).getBeanDefinition();
        }
        throw new IllegalArgumentException("The '" + String.valueOf(this.annotationType) + "' on @Bean method level is allowed only for: " + MessageSource.class.getName() + ", or " + Supplier.class.getName() + (String)(ClassUtils.KOTLIN_FUNCTION_0_CLASS != null ? ", or " + ClassUtils.KOTLIN_FUNCTION_0_CLASS.getName() : "") + " beans");
    }

    @Override
    protected BeanDefinition createEndpointBeanDefinition(ComponentDefinition handlerBeanDefinition, ComponentDefinition beanDefinition, List<Annotation> annotations) {
        String channelName = MessagingAnnotationUtils.resolveAttribute(annotations, "value", String.class);
        Assert.hasText((String)channelName, (String)"The channel ('value' attribute of @InboundChannelAdapter) can't be empty.");
        return BeanDefinitionBuilder.rootBeanDefinition(SourcePollingChannelAdapterFactoryBean.class).addPropertyValue("outputChannelName", (Object)channelName).addPropertyReference("source", handlerBeanDefinition.getName()).getBeanDefinition();
    }

    @Override
    public Object postProcess(Object bean, String beanName, Method method, List<Annotation> annotations) {
        String channelName = MessagingAnnotationUtils.resolveAttribute(annotations, "value", String.class);
        Assert.hasText((String)channelName, (String)"The channel ('value' attribute of @InboundChannelAdapter) can't be empty.");
        MessageSource<?> messageSource = this.createMessageSource(bean, beanName, method);
        SourcePollingChannelAdapter adapter = new SourcePollingChannelAdapter();
        adapter.setOutputChannelName(channelName);
        adapter.setSource(messageSource);
        Poller poller = MessagingAnnotationUtils.resolveAttribute(annotations, "poller", Poller.class);
        this.configurePollingEndpoint(adapter, poller);
        return adapter;
    }

    private MessageSource<?> createMessageSource(Object bean, String beanName, Method method) {
        MethodInvokingMessageSource methodInvokingMessageSource = new MethodInvokingMessageSource();
        methodInvokingMessageSource.setObject(bean);
        methodInvokingMessageSource.setMethod(method);
        String messageSourceBeanName = this.generateHandlerBeanName(beanName, method);
        this.getDefinitionRegistry().registerBeanDefinition(messageSourceBeanName, (BeanDefinition)new RootBeanDefinition(MethodInvokingMessageSource.class, () -> methodInvokingMessageSource));
        return (MessageSource)this.getBeanFactory().getBean(messageSourceBeanName, MessageSource.class);
    }

    @Override
    protected String generateHandlerBeanName(String originalBeanName, MergedAnnotations mergedAnnotations, @Nullable String methodName) {
        return super.generateHandlerBeanName(originalBeanName, mergedAnnotations, methodName).replaceFirst(".handler$", ".source");
    }

    @Override
    protected MessageHandler createHandler(Object bean, Method method, List<Annotation> annotations) {
        throw new UnsupportedOperationException();
    }
}

