/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.util;

import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.log.LogAccessor;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.EvaluationException;
import org.springframework.expression.Expression;
import org.springframework.expression.ExpressionParser;
import org.springframework.expression.TypeConverter;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.integration.expression.ExpressionUtils;
import org.springframework.integration.support.DefaultMessageBuilderFactory;
import org.springframework.integration.support.MessageBuilderFactory;
import org.springframework.integration.support.utils.IntegrationUtils;
import org.springframework.integration.util.BeanFactoryTypeConverter;
import org.springframework.lang.Nullable;
import org.springframework.messaging.Message;

public abstract class AbstractExpressionEvaluator
implements BeanFactoryAware,
InitializingBean {
    protected final LogAccessor logger = new LogAccessor(this.getClass());
    protected static final ExpressionParser EXPRESSION_PARSER = new SpelExpressionParser();
    private final BeanFactoryTypeConverter typeConverter = new BeanFactoryTypeConverter();
    private boolean simpleEvaluationContext;
    private volatile EvaluationContext evaluationContext;
    private volatile BeanFactory beanFactory;
    private volatile MessageBuilderFactory messageBuilderFactory = new DefaultMessageBuilderFactory();

    public void setBeanFactory(BeanFactory beanFactory) {
        this.beanFactory = beanFactory;
        this.typeConverter.setBeanFactory(beanFactory);
    }

    protected BeanFactory getBeanFactory() {
        return this.beanFactory;
    }

    public void setConversionService(ConversionService conversionService) {
        if (conversionService != null) {
            this.typeConverter.setConversionService(conversionService);
        }
    }

    protected MessageBuilderFactory getMessageBuilderFactory() {
        return this.messageBuilderFactory;
    }

    public void setSimpleEvaluationContext(boolean simpleEvaluationContext) {
        this.simpleEvaluationContext = simpleEvaluationContext;
    }

    public final void afterPropertiesSet() {
        this.getEvaluationContext();
        if (this.beanFactory != null) {
            this.messageBuilderFactory = IntegrationUtils.getMessageBuilderFactory(this.beanFactory);
        }
        this.onInit();
    }

    protected EvaluationContext getEvaluationContext() {
        return this.getEvaluationContext(true);
    }

    protected final EvaluationContext getEvaluationContext(boolean beanFactoryRequired) {
        if (this.evaluationContext == null) {
            ConversionService conversionService;
            this.evaluationContext = this.obtainEvaluationContext(beanFactoryRequired);
            EvaluationContext evaluationContext = this.evaluationContext;
            if (evaluationContext instanceof StandardEvaluationContext) {
                StandardEvaluationContext standardEvaluationContext = (StandardEvaluationContext)evaluationContext;
                standardEvaluationContext.setTypeConverter((TypeConverter)this.typeConverter);
            }
            if (this.beanFactory != null && (conversionService = IntegrationUtils.getConversionService(this.beanFactory)) != null) {
                this.typeConverter.setConversionService(conversionService);
            }
        }
        return this.evaluationContext;
    }

    private EvaluationContext obtainEvaluationContext(boolean beanFactoryRequired) {
        if (this.beanFactory == null && !beanFactoryRequired) {
            return this.simpleEvaluationContext ? ExpressionUtils.createSimpleEvaluationContext() : ExpressionUtils.createStandardEvaluationContext();
        }
        return this.simpleEvaluationContext ? ExpressionUtils.createSimpleEvaluationContext(this.beanFactory) : ExpressionUtils.createStandardEvaluationContext(this.beanFactory);
    }

    @Nullable
    protected <T> T evaluateExpression(Expression expression, Message<?> message, @Nullable Class<T> expectedType) {
        try {
            return this.evaluateExpression(expression, (Object)message, expectedType);
        }
        catch (Exception ex) {
            this.logger.debug((Throwable)ex, (CharSequence)"SpEL Expression evaluation failed with Exception.");
            Throwable cause = null;
            if (ex instanceof EvaluationException) {
                cause = ex.getCause();
            }
            throw IntegrationUtils.wrapInHandlingExceptionIfNecessary(message, () -> "Expression evaluation failed: " + expression.getExpressionString(), cause == null ? ex : cause);
        }
    }

    @Nullable
    protected Object evaluateExpression(String expression, Object input) {
        return this.evaluateExpression(expression, input, null);
    }

    @Nullable
    protected <T> T evaluateExpression(String expression, Object input, @Nullable Class<T> expectedType) {
        return (T)EXPRESSION_PARSER.parseExpression(expression).getValue(this.getEvaluationContext(), input, expectedType);
    }

    @Nullable
    protected Object evaluateExpression(Expression expression, Object input) {
        return this.evaluateExpression(expression, input, null);
    }

    @Nullable
    protected <T> T evaluateExpression(Expression expression, @Nullable Class<T> expectedType) {
        return (T)expression.getValue(this.getEvaluationContext(), expectedType);
    }

    @Nullable
    protected Object evaluateExpression(Expression expression) {
        return expression.getValue(this.getEvaluationContext());
    }

    @Nullable
    protected <T> T evaluateExpression(Expression expression, Object input, @Nullable Class<T> expectedType) {
        return (T)expression.getValue(this.getEvaluationContext(), input, expectedType);
    }

    protected void onInit() {
    }
}

