/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.events;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.syncope.client.console.events.EventCategory;
import org.apache.syncope.client.console.events.SelectedEventsPanel;
import org.apache.syncope.client.ui.commons.ajax.form.IndicatorAjaxFormChoiceComponentUpdatingBehavior;
import org.apache.syncope.common.lib.types.OpEvent;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.form.AjaxFormChoiceComponentUpdatingBehavior;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.event.Broadcast;
import org.apache.wicket.event.IEvent;
import org.apache.wicket.event.IEventSink;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.Check;
import org.apache.wicket.markup.html.form.CheckGroup;
import org.apache.wicket.markup.html.form.CheckGroupSelector;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.ResourceModel;

public abstract class EventSelectionPanel
extends Panel {
    private static final long serialVersionUID = 752233163798301002L;
    private final Set<String> selected = new HashSet<String>();

    public EventSelectionPanel(String id, final EventCategory eventCategory, IModel<List<String>> model) {
        super(id);
        this.setOutputMarkupId(true);
        List<String> ops = this.getOps(eventCategory);
        this.selected.addAll((Collection)model.getObject());
        final CheckGroup successGroup = new CheckGroup("successGroup", this.selected);
        successGroup.add(new Behavior[]{new AjaxFormChoiceComponentUpdatingBehavior(){
            private static final long serialVersionUID = -151291731388673682L;

            protected void onUpdate(AjaxRequestTarget target) {
                HashSet<OpEvent> toBeRemoved = new HashSet<OpEvent>();
                HashSet<OpEvent> toBeAdded = new HashSet<OpEvent>();
                EventSelectionPanel.this.getOps(eventCategory).forEach(event -> {
                    OpEvent opEvent = new OpEvent(eventCategory.getType(), eventCategory.getCategory(), eventCategory.getSubcategory(), event, OpEvent.Outcome.SUCCESS);
                    if (((Collection)successGroup.getModelObject()).contains(opEvent.toString())) {
                        toBeAdded.add(opEvent);
                    } else {
                        toBeRemoved.add(opEvent);
                    }
                });
                EventSelectionPanel.this.send((IEventSink)EventSelectionPanel.this.getPage(), Broadcast.BREADTH, new SelectedEventsPanel.EventSelectionChanged(target, toBeAdded, toBeRemoved));
            }
        }});
        successGroup.setVisible(!ops.isEmpty());
        this.add(new Component[]{successGroup});
        this.add(new Component[]{new Label("successLabel", (IModel)new ResourceModel("Success", "Success"))}).setVisible(!ops.isEmpty());
        CheckGroupSelector successSelector = new CheckGroupSelector("successSelector", successGroup);
        successSelector.setVisible(!ops.isEmpty());
        this.add(new Component[]{successSelector});
        ListView<String> categoryView = new ListView<String>("categoryView", ops){
            private static final long serialVersionUID = 4949588177564901031L;

            protected void populateItem(ListItem<String> item) {
                item.add(new Component[]{new Label("subcategory", (IModel)Model.of((Serializable)((Object)((String)item.getModelObject()))))});
            }
        };
        this.add(new Component[]{categoryView});
        ListView<String> successView = new ListView<String>("successView", ops){
            private static final long serialVersionUID = 4949588177564901031L;

            protected void populateItem(ListItem<String> item) {
                item.add(new Component[]{new Check("successCheck", (IModel)new Model((Serializable)((Object)OpEvent.toString((OpEvent.CategoryType)eventCategory.getType(), (String)eventCategory.getCategory(), (String)eventCategory.getSubcategory(), (String)((String)item.getModelObject()), (OpEvent.Outcome)OpEvent.Outcome.SUCCESS))), successGroup)});
            }
        };
        successGroup.add(new Component[]{successView});
        final CheckGroup failureGroup = new CheckGroup("failureGroup", this.selected);
        failureGroup.add(new Behavior[]{new IndicatorAjaxFormChoiceComponentUpdatingBehavior(){
            private static final long serialVersionUID = -151291731388673682L;

            protected void onUpdate(AjaxRequestTarget target) {
                HashSet<OpEvent> toBeRemoved = new HashSet<OpEvent>();
                HashSet<OpEvent> toBeAdded = new HashSet<OpEvent>();
                EventSelectionPanel.this.getOps(eventCategory).forEach(event -> {
                    OpEvent opEvent = new OpEvent(eventCategory.getType(), eventCategory.getCategory(), eventCategory.getSubcategory(), event, OpEvent.Outcome.FAILURE);
                    if (((Collection)failureGroup.getModelObject()).contains(opEvent.toString())) {
                        toBeAdded.add(opEvent);
                    } else {
                        toBeRemoved.add(opEvent);
                    }
                });
                EventSelectionPanel.this.send((IEventSink)EventSelectionPanel.this.getPage(), Broadcast.BREADTH, new SelectedEventsPanel.EventSelectionChanged(target, toBeAdded, toBeRemoved));
            }
        }});
        failureGroup.setVisible(!ops.isEmpty());
        this.add(new Component[]{failureGroup});
        this.add(new Component[]{new Label("failureLabel", (IModel)new ResourceModel("Failure", "Failure"))}).setVisible(!ops.isEmpty());
        CheckGroupSelector failureSelector = new CheckGroupSelector("failureSelector", failureGroup);
        failureSelector.setVisible(!ops.isEmpty());
        this.add(new Component[]{failureSelector});
        ListView<String> failureView = new ListView<String>("failureView", ops){
            private static final long serialVersionUID = 4949588177564901031L;

            protected void populateItem(ListItem<String> item) {
                item.add(new Component[]{new Check("failureCheck", (IModel)new Model((Serializable)((Object)OpEvent.toString((OpEvent.CategoryType)eventCategory.getType(), (String)eventCategory.getCategory(), (String)eventCategory.getSubcategory(), (String)((String)item.getModelObject()), (OpEvent.Outcome)OpEvent.Outcome.FAILURE))), failureGroup)});
            }
        };
        failureGroup.add(new Component[]{failureView});
    }

    private List<String> getOps(EventCategory eventCategoryTO) {
        List<String> ops = eventCategoryTO.getOps();
        if (ops.isEmpty()) {
            if ((OpEvent.CategoryType.PROPAGATION == eventCategoryTO.getType() || OpEvent.CategoryType.PULL == eventCategoryTO.getType() || OpEvent.CategoryType.PUSH == eventCategoryTO.getType()) && StringUtils.isEmpty((CharSequence)eventCategoryTO.getCategory())) {
                ops.add(eventCategoryTO.getType().toString());
            } else if (OpEvent.CategoryType.TASK == eventCategoryTO.getType() && StringUtils.isNotEmpty((CharSequence)eventCategoryTO.getCategory())) {
                ops.add(eventCategoryTO.getCategory());
            } else if (OpEvent.CategoryType.REPORT == eventCategoryTO.getType() && StringUtils.isNotEmpty((CharSequence)eventCategoryTO.getCategory())) {
                ops.add(eventCategoryTO.getCategory());
            }
        } else {
            Collections.sort(ops);
        }
        return ops;
    }

    protected abstract void onEventAction(IEvent<?> var1);

    public void onEvent(IEvent<?> event) {
        this.onEventAction(event);
    }
}

