/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.coordinator.group.metrics;

import java.util.Arrays;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Supplier;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.metrics.Gauge;
import org.apache.kafka.common.metrics.MeasurableStat;
import org.apache.kafka.common.metrics.MetricValueProvider;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.metrics.stats.Avg;
import org.apache.kafka.common.metrics.stats.Max;
import org.apache.kafka.common.metrics.stats.Rate;
import org.apache.kafka.coordinator.group.metrics.CoordinatorRuntimeMetrics;
import org.apache.kafka.coordinator.group.runtime.CoordinatorRuntime;

public class GroupCoordinatorRuntimeMetrics
implements CoordinatorRuntimeMetrics {
    public static final String METRICS_GROUP = "group-coordinator-metrics";
    public static final String NUM_PARTITIONS_METRIC_NAME = "num-partitions";
    private final MetricName numPartitionsLoading;
    private final AtomicLong numPartitionsLoadingCounter = new AtomicLong(0L);
    private final MetricName numPartitionsActive;
    private final AtomicLong numPartitionsActiveCounter = new AtomicLong(0L);
    private final MetricName numPartitionsFailed;
    private final AtomicLong numPartitionsFailedCounter = new AtomicLong(0L);
    private final MetricName eventQueueSize;
    private final Metrics metrics;
    private final Sensor partitionLoadSensor;
    private final Sensor threadIdleSensor;

    public GroupCoordinatorRuntimeMetrics(Metrics metrics) {
        this.metrics = Objects.requireNonNull(metrics);
        this.numPartitionsLoading = this.kafkaMetricName(NUM_PARTITIONS_METRIC_NAME, "The number of partitions in Loading state.", "state", "loading");
        this.numPartitionsActive = this.kafkaMetricName(NUM_PARTITIONS_METRIC_NAME, "The number of partitions in Active state.", "state", "active");
        this.numPartitionsFailed = this.kafkaMetricName(NUM_PARTITIONS_METRIC_NAME, "The number of partitions in Failed state.", "state", "failed");
        this.eventQueueSize = this.kafkaMetricName("event-queue-size", "The event accumulator queue size.", new String[0]);
        metrics.addMetric(this.numPartitionsLoading, (MetricValueProvider)((Gauge)(config, now) -> this.numPartitionsLoadingCounter.get()));
        metrics.addMetric(this.numPartitionsActive, (MetricValueProvider)((Gauge)(config, now) -> this.numPartitionsActiveCounter.get()));
        metrics.addMetric(this.numPartitionsFailed, (MetricValueProvider)((Gauge)(config, now) -> this.numPartitionsFailedCounter.get()));
        this.partitionLoadSensor = metrics.sensor("GroupPartitionLoadTime");
        this.partitionLoadSensor.add(metrics.metricName("partition-load-time-max", METRICS_GROUP, "The max time it took to load the partitions in the last 30 sec."), (MeasurableStat)new Max());
        this.partitionLoadSensor.add(metrics.metricName("partition-load-time-avg", METRICS_GROUP, "The average time it took to load the partitions in the last 30 sec."), (MeasurableStat)new Avg());
        this.threadIdleSensor = metrics.sensor("ThreadIdleRatio");
        this.threadIdleSensor.add(metrics.metricName("thread-idle-ratio-avg", METRICS_GROUP, "The fraction of time the threads spent waiting for an event. This is an average across all coordinator event processor threads."), (MeasurableStat)new Rate(TimeUnit.MILLISECONDS));
    }

    private MetricName kafkaMetricName(String name, String description, String ... keyValue) {
        return this.metrics.metricName(name, METRICS_GROUP, description, keyValue);
    }

    @Override
    public void close() {
        Arrays.asList(this.numPartitionsLoading, this.numPartitionsActive, this.numPartitionsFailed, this.eventQueueSize).forEach(arg_0 -> ((Metrics)this.metrics).removeMetric(arg_0));
        this.metrics.removeSensor(this.partitionLoadSensor.name());
        this.metrics.removeSensor(this.threadIdleSensor.name());
    }

    @Override
    public void recordPartitionStateChange(CoordinatorRuntime.CoordinatorState oldState, CoordinatorRuntime.CoordinatorState newState) {
        switch (oldState) {
            case INITIAL: 
            case CLOSED: {
                break;
            }
            case LOADING: {
                this.numPartitionsLoadingCounter.decrementAndGet();
                break;
            }
            case ACTIVE: {
                this.numPartitionsActiveCounter.decrementAndGet();
                break;
            }
            case FAILED: {
                this.numPartitionsFailedCounter.decrementAndGet();
            }
        }
        switch (newState) {
            case INITIAL: 
            case CLOSED: {
                break;
            }
            case LOADING: {
                this.numPartitionsLoadingCounter.incrementAndGet();
                break;
            }
            case ACTIVE: {
                this.numPartitionsActiveCounter.incrementAndGet();
                break;
            }
            case FAILED: {
                this.numPartitionsFailedCounter.incrementAndGet();
            }
        }
    }

    @Override
    public void recordPartitionLoadSensor(long startTimeMs, long endTimeMs) {
        this.partitionLoadSensor.record((double)(endTimeMs - startTimeMs), endTimeMs, false);
    }

    @Override
    public void recordEventQueueTime(long durationMs) {
    }

    @Override
    public void recordEventQueueProcessingTime(long durationMs) {
    }

    @Override
    public void recordThreadIdleTime(long idleTimeMs) {
        this.threadIdleSensor.record((double)idleTimeMs);
    }

    @Override
    public void registerEventQueueSizeGauge(Supplier<Integer> sizeSupplier) {
        this.metrics.addMetric(this.eventQueueSize, (MetricValueProvider)((Gauge)(config, now) -> (long)((Integer)sizeSupplier.get())));
    }
}

