/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.oauth.profile.qq;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.scribejava.core.exceptions.OAuthException;
import com.github.scribejava.core.model.OAuth2AccessToken;
import com.github.scribejava.core.model.Token;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.pac4j.core.profile.AttributeLocation;
import org.pac4j.core.profile.UserProfile;
import org.pac4j.core.profile.converter.AttributeConverter;
import org.pac4j.core.profile.converter.Converters;
import org.pac4j.core.profile.converter.DateConverter;
import org.pac4j.core.profile.converter.GenderConverter;
import org.pac4j.oauth.config.OAuth20Configuration;
import org.pac4j.oauth.config.OAuthConfiguration;
import org.pac4j.oauth.profile.JsonHelper;
import org.pac4j.oauth.profile.definition.OAuthProfileDefinition;
import org.pac4j.oauth.profile.qq.QQProfile;

public class QQProfileDefinition
extends OAuthProfileDefinition {
    public static final Pattern OPENID_REGEX = Pattern.compile("\"openid\"\\s*:\\s*\"(\\S*?)\"");
    public static final String RET = "ret";
    public static final String MSG = "msg";
    public static final String NICKNAME = "nickname";
    public static final String PROVINCE = "province";
    public static final String CITY = "city";
    public static final String YEAR = "year";
    public static final String FIGUREURL = "figureurl";
    public static final String FIGUREURL_1 = "figureurl_1";
    public static final String FIGUREURL_2 = "figureurl_2";
    public static final String FIGUREURL_QQ_1 = "figureurl_qq_1";
    public static final String FIGUREURL_QQ_2 = "figureurl_qq_2";

    public QQProfileDefinition() {
        Arrays.stream(new String[]{MSG, NICKNAME, PROVINCE, CITY, YEAR}).forEach(a -> this.primary((String)a, Converters.STRING));
        Arrays.stream(new String[]{FIGUREURL, FIGUREURL_1, FIGUREURL_2, FIGUREURL_QQ_1, FIGUREURL_QQ_2}).forEach(a -> this.primary((String)a, Converters.URL));
        this.primary(RET, Converters.INTEGER);
        this.primary("gender", (AttributeConverter)new GenderConverter("\u7537", "\u5973"));
        this.primary(YEAR, (AttributeConverter)new DateConverter("yyyy"));
    }

    public String getOpenidUrl(OAuth2AccessToken accessToken, OAuth20Configuration configuration) {
        return "https://graph.qq.com/oauth2.0/me";
    }

    @Override
    public String getProfileUrl(Token accessToken, OAuthConfiguration configuration) {
        return "https://graph.qq.com/user/get_user_info";
    }

    @Override
    public QQProfile extractUserProfile(String body) {
        QQProfile profile = new QQProfile();
        JsonNode json = JsonHelper.getFirstNode(body);
        if (json != null) {
            for (String attribute : this.getPrimaryAttributes()) {
                this.convertAndAdd((UserProfile)profile, AttributeLocation.PROFILE_ATTRIBUTE, attribute, JsonHelper.getElement(json, attribute));
            }
        } else {
            this.raiseProfileExtractionJsonError(body);
        }
        return profile;
    }

    public String extractOpenid(String body) {
        String openid = QQProfileDefinition.extractParameter(body, OPENID_REGEX, true);
        return openid;
    }

    protected static String extractParameter(CharSequence response, Pattern regexPattern, boolean required) throws OAuthException {
        Matcher matcher = regexPattern.matcher(response);
        if (matcher.find()) {
            return matcher.group(1);
        }
        if (required) {
            throw new OAuthException("Response body is incorrect. Can't extract a '" + regexPattern.pattern() + "' from this: '" + response + "'", null);
        }
        return null;
    }
}

