/*
 * Decompiled with CFR 0.152.
 */
package com.yubico.webauthn.data;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.upokecenter.cbor.CBORObject;
import com.yubico.internal.util.CollectionUtil;
import com.yubico.webauthn.data.AuthenticatorData;
import com.yubico.webauthn.data.AuthenticatorExtensionOutputs;
import com.yubico.webauthn.data.Extensions;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonIgnoreProperties(ignoreUnknown=true)
public final class AuthenticatorAssertionExtensionOutputs
implements AuthenticatorExtensionOutputs {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AuthenticatorAssertionExtensionOutputs.class);
    private final List<Extensions.Uvm.UvmEntry> uvm;

    @JsonCreator
    private AuthenticatorAssertionExtensionOutputs(@JsonProperty(value="uvm") List<Extensions.Uvm.UvmEntry> uvm) {
        this.uvm = uvm == null ? null : CollectionUtil.immutableList(uvm);
    }

    public static Optional<AuthenticatorAssertionExtensionOutputs> fromAuthenticatorData(AuthenticatorData authData) {
        return authData.getExtensions().flatMap(AuthenticatorAssertionExtensionOutputs::fromCbor);
    }

    static Optional<AuthenticatorAssertionExtensionOutputs> fromCbor(CBORObject cbor) {
        AuthenticatorAssertionExtensionOutputsBuilder b = AuthenticatorAssertionExtensionOutputs.builder();
        Extensions.Uvm.parseAuthenticatorExtensionOutput(cbor).ifPresent(b::uvm);
        AuthenticatorAssertionExtensionOutputs result = b.build();
        if (result.getExtensionIds().isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(result);
    }

    @Override
    public Set<String> getExtensionIds() {
        HashSet<String> ids = new HashSet<String>();
        if (this.uvm != null) {
            ids.add("uvm");
        }
        return ids;
    }

    public Optional<List<Extensions.Uvm.UvmEntry>> getUvm() {
        return Optional.ofNullable(this.uvm);
    }

    @Generated
    public static AuthenticatorAssertionExtensionOutputsBuilder builder() {
        return new AuthenticatorAssertionExtensionOutputsBuilder();
    }

    @Generated
    public AuthenticatorAssertionExtensionOutputsBuilder toBuilder() {
        return new AuthenticatorAssertionExtensionOutputsBuilder().uvm(this.uvm);
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AuthenticatorAssertionExtensionOutputs)) {
            return false;
        }
        AuthenticatorAssertionExtensionOutputs other = (AuthenticatorAssertionExtensionOutputs)o;
        Optional<List<Extensions.Uvm.UvmEntry>> this$uvm = this.getUvm();
        Optional<List<Extensions.Uvm.UvmEntry>> other$uvm = other.getUvm();
        if (this$uvm == null ? other$uvm != null : !((Object)this$uvm).equals(other$uvm)) {
            return false;
        }
        Set<String> this$$getExtensionIds = this.getExtensionIds();
        Set<String> other$$getExtensionIds = other.getExtensionIds();
        return !(this$$getExtensionIds == null ? other$$getExtensionIds != null : !((Object)this$$getExtensionIds).equals(other$$getExtensionIds));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Optional<List<Extensions.Uvm.UvmEntry>> $uvm = this.getUvm();
        result = result * 59 + ($uvm == null ? 43 : ((Object)$uvm).hashCode());
        Set<String> $$getExtensionIds = this.getExtensionIds();
        result = result * 59 + ($$getExtensionIds == null ? 43 : ((Object)$$getExtensionIds).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "AuthenticatorAssertionExtensionOutputs(uvm=" + this.getUvm() + ")";
    }

    @Generated
    public static class AuthenticatorAssertionExtensionOutputsBuilder {
        @Generated
        private List<Extensions.Uvm.UvmEntry> uvm;

        @Generated
        AuthenticatorAssertionExtensionOutputsBuilder() {
        }

        @Generated
        public AuthenticatorAssertionExtensionOutputsBuilder uvm(List<Extensions.Uvm.UvmEntry> uvm) {
            this.uvm = uvm;
            return this;
        }

        @Generated
        public AuthenticatorAssertionExtensionOutputs build() {
            return new AuthenticatorAssertionExtensionOutputs(this.uvm);
        }

        @Generated
        public String toString() {
            return "AuthenticatorAssertionExtensionOutputs.AuthenticatorAssertionExtensionOutputsBuilder(uvm=" + this.uvm + ")";
        }
    }
}

