/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.jquery.ui.form.autocomplete;

import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.attributes.CallbackParameter;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.util.lang.Args;
import org.wicketstuff.jquery.core.JQueryEvent;
import org.wicketstuff.jquery.core.Options;
import org.wicketstuff.jquery.core.ajax.IJQueryAjaxAware;
import org.wicketstuff.jquery.core.ajax.JQueryAjaxBehavior;
import org.wicketstuff.jquery.core.utils.RequestCycleUtils;
import org.wicketstuff.jquery.ui.JQueryUIBehavior;
import org.wicketstuff.jquery.ui.form.autocomplete.IAutoCompleteListener;

public abstract class AutoCompleteBehavior
extends JQueryUIBehavior
implements IJQueryAjaxAware {
    private static final long serialVersionUID = 1L;
    public static final String METHOD = "autocomplete";
    private final IAutoCompleteListener listener;
    private JQueryAjaxBehavior onSelectAjaxBehavior = null;

    public AutoCompleteBehavior(String selector, IAutoCompleteListener listener) {
        this(selector, new Options(), listener);
    }

    public AutoCompleteBehavior(String selector, Options options, IAutoCompleteListener listener) {
        super(selector, METHOD, options);
        this.listener = (IAutoCompleteListener)Args.notNull((Object)listener, (String)"listener");
    }

    public void bind(Component component) {
        super.bind(component);
        this.onSelectAjaxBehavior = this.newOnSelectAjaxBehavior(this);
        component.add(new Behavior[]{this.onSelectAjaxBehavior});
    }

    public boolean isEnabled(Component component) {
        return component.isEnabledInHierarchy();
    }

    protected abstract CharSequence getChoiceCallbackUrl();

    @Override
    public void onConfigure(Component component) {
        this.setOption("select", this.onSelectAjaxBehavior.getCallbackFunction());
        if (this.isEnabled(component)) {
            this.setOption("source", Options.asString((Object)this.getChoiceCallbackUrl()));
        }
        super.onConfigure(component);
    }

    public void onAjax(AjaxRequestTarget target, JQueryEvent event) {
        if (event instanceof SelectEvent) {
            this.listener.onSelect(target, ((SelectEvent)event).getIndex());
        }
    }

    protected JQueryAjaxBehavior newOnSelectAjaxBehavior(IJQueryAjaxAware source) {
        return new OnSelectAjaxBehavior(source);
    }

    protected static class SelectEvent
    extends JQueryEvent {
        private final int index = RequestCycleUtils.getQueryParameterValue((String)"index").toInt(0);

        public int getIndex() {
            return this.index;
        }
    }

    protected static class OnSelectAjaxBehavior
    extends JQueryAjaxBehavior {
        private static final long serialVersionUID = 1L;

        public OnSelectAjaxBehavior(IJQueryAjaxAware source) {
            super(source);
        }

        protected CallbackParameter[] getCallbackParameters() {
            return new CallbackParameter[]{CallbackParameter.context((String)"event"), CallbackParameter.context((String)"ui"), CallbackParameter.resolved((String)"index", (String)"ui.item.id")};
        }

        protected JQueryEvent newEvent() {
            return new SelectEvent();
        }
    }
}

