/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.lib;

import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import jakarta.ws.rs.core.MediaType;
import java.io.IOException;
import java.io.InputStream;
import java.util.Base64;
import org.apache.commons.lang3.Strings;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.cxf.configuration.jsse.TLSClientParameters;
import org.apache.cxf.jaxrs.client.JAXRSClientFactoryBean;
import org.apache.cxf.jaxrs.client.WebClient;
import org.apache.cxf.transports.http.configuration.HTTPClientPolicy;
import org.apache.syncope.client.lib.AnonymousAuthenticationHandler;
import org.apache.syncope.client.lib.RestClientExceptionMapper;
import org.apache.syncope.client.lib.SyncopeClient;
import org.apache.syncope.client.lib.WebClientBuilder;
import org.apache.syncope.common.lib.info.NumbersInfo;
import org.apache.syncope.common.lib.info.PlatformInfo;
import org.apache.syncope.common.lib.info.SystemInfo;

public class SyncopeAnonymousClient
extends SyncopeClient {
    protected final AnonymousAuthenticationHandler anonymousAuthHandler;

    public SyncopeAnonymousClient(MediaType mediaType, JAXRSClientFactoryBean restClientFactory, RestClientExceptionMapper exceptionMapper, AnonymousAuthenticationHandler anonymousAuthHandler, boolean useCompression, HTTPClientPolicy httpClientPolicy, TLSClientParameters tlsClientParameters) {
        super(mediaType, restClientFactory, exceptionMapper, anonymousAuthHandler, useCompression, httpClientPolicy, tlsClientParameters);
        this.anonymousAuthHandler = anonymousAuthHandler;
    }

    public JsonNode info() throws IOException {
        WebClient webClient = WebClientBuilder.build(Strings.CS.removeEnd(this.restClientFactory.getAddress().replace("/rest", "/actuator/info"), (CharSequence)"/")).accept(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).header("X-Syncope-Domain", new Object[]{this.getDomain()}).header("Authorization", new Object[]{"Basic " + Base64.getEncoder().encodeToString((this.anonymousAuthHandler.getUsername() + ":" + this.anonymousAuthHandler.getPassword()).getBytes())});
        return MAPPER.readTree((InputStream)webClient.get().getEntity());
    }

    public Pair<String, String> gitAndBuildInfo() {
        try {
            JsonNode info = this.info();
            return Pair.of((Object)(info.has("git") && info.get("git").has("commit") && info.get("git").get("commit").has("id") ? info.get("git").get("commit").get("id").asText() : ""), (Object)info.get("build").get("version").asText());
        }
        catch (IOException e) {
            throw new RuntimeException("While getting build and git Info", e);
        }
    }

    public PlatformInfo platform() {
        try {
            return (PlatformInfo)MAPPER.treeToValue((TreeNode)this.info().get("platform"), PlatformInfo.class);
        }
        catch (IOException e) {
            throw new RuntimeException("While getting Platform Info", e);
        }
    }

    public SystemInfo system() {
        try {
            return (SystemInfo)MAPPER.treeToValue((TreeNode)this.info().get("system"), SystemInfo.class);
        }
        catch (IOException e) {
            throw new RuntimeException("While getting System Info", e);
        }
    }

    public NumbersInfo numbers() {
        try {
            return (NumbersInfo)MAPPER.treeToValue((TreeNode)this.info().get("numbers"), NumbersInfo.class);
        }
        catch (IOException e) {
            throw new RuntimeException("While getting Numbers Info", e);
        }
    }
}

