/*
 * Decompiled with CFR 0.152.
 */
package net.tirasa.connid.bundles.kafka;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import java.time.Duration;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;
import net.tirasa.connid.bundles.kafka.KafkaConfiguration;
import net.tirasa.connid.bundles.kafka.serialization.AttributeDeserializer;
import net.tirasa.connid.bundles.kafka.serialization.AttributeSerializer;
import net.tirasa.connid.bundles.kafka.serialization.ConnectorObjectDeserializer;
import net.tirasa.connid.bundles.kafka.serialization.GuardedStringDeserializer;
import net.tirasa.connid.bundles.kafka.serialization.GuardedStringSerializer;
import net.tirasa.connid.bundles.kafka.serialization.SyncDeltaJacksonDeserializer;
import net.tirasa.connid.bundles.kafka.serialization.SyncTokenDeserializer;
import net.tirasa.connid.bundles.kafka.serialization.SyncTokenSerializer;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.serialization.StringDeserializer;
import org.apache.kafka.common.serialization.StringSerializer;
import org.identityconnectors.common.logging.Log;
import org.identityconnectors.common.security.GuardedString;
import org.identityconnectors.framework.common.exceptions.ConnectionFailedException;
import org.identityconnectors.framework.common.exceptions.ConnectorException;
import org.identityconnectors.framework.common.exceptions.PreconditionFailedException;
import org.identityconnectors.framework.common.objects.Attribute;
import org.identityconnectors.framework.common.objects.AttributeUtil;
import org.identityconnectors.framework.common.objects.ConnectorObject;
import org.identityconnectors.framework.common.objects.ConnectorObjectBuilder;
import org.identityconnectors.framework.common.objects.LiveSyncDeltaBuilder;
import org.identityconnectors.framework.common.objects.LiveSyncResultsHandler;
import org.identityconnectors.framework.common.objects.Name;
import org.identityconnectors.framework.common.objects.ObjectClass;
import org.identityconnectors.framework.common.objects.OperationOptions;
import org.identityconnectors.framework.common.objects.Schema;
import org.identityconnectors.framework.common.objects.SyncDelta;
import org.identityconnectors.framework.common.objects.SyncDeltaBuilder;
import org.identityconnectors.framework.common.objects.SyncDeltaType;
import org.identityconnectors.framework.common.objects.SyncToken;
import org.identityconnectors.framework.common.objects.Uid;
import org.identityconnectors.framework.spi.Configuration;
import org.identityconnectors.framework.spi.ConnectorClass;
import org.identityconnectors.framework.spi.PoolableConnector;
import org.identityconnectors.framework.spi.operations.CreateOp;
import org.identityconnectors.framework.spi.operations.DeleteOp;
import org.identityconnectors.framework.spi.operations.LiveSyncOp;
import org.identityconnectors.framework.spi.operations.SchemaOp;
import org.identityconnectors.framework.spi.operations.TestOp;
import org.identityconnectors.framework.spi.operations.UpdateOp;

@ConnectorClass(configurationClass=KafkaConfiguration.class, displayNameKey="kafka.connector.display")
public class KafkaConnector
implements PoolableConnector,
CreateOp,
UpdateOp,
DeleteOp,
SchemaOp,
LiveSyncOp,
TestOp {
    private static final Log LOG = Log.getLog(KafkaConnector.class);
    public static final JsonMapper MAPPER;
    private KafkaConfiguration configuration;
    private KafkaProducer<String, Object> producer;

    public KafkaConfiguration getConfiguration() {
        return this.configuration;
    }

    public void init(Configuration configuration) {
        this.configuration = (KafkaConfiguration)configuration;
        this.configuration.validate();
        Properties props = new Properties();
        props.put("bootstrap.servers", this.configuration.getBootstrapServers());
        props.put("client.id", this.configuration.getClientId());
        props.put("key.serializer", StringSerializer.class.getName());
        props.put("value.serializer", this.configuration.getValueSerializerClassName());
        try {
            this.producer = new KafkaProducer(props);
        }
        catch (KafkaException e) {
            LOG.error((Throwable)e, "While creating Kafka producer", new Object[0]);
            throw new ConnectionFailedException((Throwable)e);
        }
        LOG.ok("Connector {0} successfully inited", new Object[]{this.getClass().getName()});
    }

    public void dispose() {
        try {
            Optional.ofNullable(this.producer).ifPresent(KafkaProducer::close);
        }
        catch (KafkaException e) {
            LOG.error((Throwable)e, "While closing Kafka producer", new Object[0]);
            throw new ConnectorException((Throwable)e);
        }
    }

    private KafkaConsumer<String, Object> createConsumer(ObjectClass objectClass) {
        Properties props = new Properties();
        props.put("bootstrap.servers", this.configuration.getBootstrapServers());
        props.put("client.id", this.configuration.getClientId());
        props.put("group.id", this.configuration.getConsumerGroupId());
        props.put("auto.offset.reset", this.configuration.getAutoOffsetReset());
        props.put("key.deserializer", StringDeserializer.class.getName());
        props.put("value.deserializer", this.configuration.getValueDeserializerClassName());
        KafkaConsumer consumer = new KafkaConsumer(props);
        consumer.subscribe(List.of(this.getTopic(objectClass)));
        return consumer;
    }

    public void test() {
        if (this.producer == null) {
            throw new ConnectorException("No Kafka producer configured");
        }
        try {
            this.producer.metrics();
        }
        catch (Exception e) {
            LOG.error((Throwable)e, "While testing Kafka producer", new Object[0]);
            throw new ConnectionFailedException((Throwable)e);
        }
        try (KafkaConsumer<String, Object> consumer = this.createConsumer(ObjectClass.ACCOUNT);){
            consumer.listTopics(Duration.ofSeconds(10L));
        }
        catch (Exception e) {
            LOG.error((Throwable)e, "While testing Kafka consumer", new Object[0]);
            throw new ConnectionFailedException((Throwable)e);
        }
    }

    public void checkAlive() {
        this.test();
    }

    public Schema schema() {
        return new Schema(Collections.emptySet(), Collections.emptySet(), Collections.emptyMap(), Collections.emptyMap());
    }

    private String getTopic(ObjectClass objectClass) {
        if (ObjectClass.ACCOUNT.equals((Object)objectClass)) {
            return this.configuration.getAccountTopic();
        }
        if (ObjectClass.GROUP.equals((Object)objectClass)) {
            return this.configuration.getGroupTopic();
        }
        if (ObjectClass.ALL.equals((Object)objectClass)) {
            return this.configuration.getAllTopic();
        }
        throw new PreconditionFailedException("Unsupported object class: " + objectClass.getObjectClassValue());
    }

    public Uid create(ObjectClass objectClass, Set<Attribute> createAttributes, OperationOptions options) {
        Uid uid = new Uid(Optional.ofNullable(AttributeUtil.getNameFromAttributes(createAttributes)).orElseThrow(() -> new ConnectorException(Name.NAME + " not found in create attributes")).getNameValue());
        SyncDelta syncDelta = new SyncDeltaBuilder().setDeltaType(SyncDeltaType.CREATE).setObjectClass(objectClass).setUid(uid).setObject(new ConnectorObjectBuilder().addAttributes(createAttributes).setUid(uid).build()).setToken(new SyncToken((Object)System.currentTimeMillis())).build();
        try {
            this.producer.send(new ProducerRecord(this.getTopic(objectClass), (Object)syncDelta));
        }
        catch (Exception e) {
            throw new ConnectorException("Could not send the create event to " + this.getTopic(objectClass), (Throwable)e);
        }
        return uid;
    }

    public Uid update(ObjectClass objectClass, Uid uid, Set<Attribute> replaceAttributes, OperationOptions options) {
        SyncDelta syncDelta = new SyncDeltaBuilder().setDeltaType(SyncDeltaType.UPDATE).setObjectClass(objectClass).setUid(uid).setObject(new ConnectorObjectBuilder().addAttributes(replaceAttributes).setUid(uid).build()).setToken(new SyncToken((Object)System.currentTimeMillis())).build();
        try {
            this.producer.send(new ProducerRecord(this.getTopic(objectClass), (Object)syncDelta));
        }
        catch (Exception e) {
            throw new ConnectorException("Could not send the update event to " + this.getTopic(objectClass), (Throwable)e);
        }
        return uid;
    }

    public void delete(ObjectClass objectClass, Uid uid, OperationOptions options) {
        SyncDelta syncDelta = new SyncDeltaBuilder().setDeltaType(SyncDeltaType.DELETE).setObjectClass(objectClass).setUid(uid).setToken(new SyncToken((Object)System.currentTimeMillis())).build();
        try {
            this.producer.send(new ProducerRecord(this.getTopic(objectClass), (Object)syncDelta));
        }
        catch (Exception e) {
            throw new ConnectorException("Could not send the delete event to " + this.getTopic(objectClass), (Throwable)e);
        }
    }

    public void livesync(ObjectClass objectClass, LiveSyncResultsHandler handler, OperationOptions options) {
        try (KafkaConsumer<String, Object> consumer = this.createConsumer(objectClass);){
            consumer.poll(Duration.ofMillis(this.configuration.getConsumerPollMillis())).forEach(record -> {
                LOG.ok("Processing {0} for topic {1}", new Object[]{record.key(), record.topic()});
                Uid uid = new Uid(Optional.ofNullable((String)record.key()).orElseGet(() -> UUID.randomUUID().toString()));
                HashMap headers = new HashMap();
                record.headers().forEach(header -> headers.put(header.key(), new String(header.value())));
                try {
                    ConnectorObjectBuilder object = new ConnectorObjectBuilder().setObjectClass(objectClass).setUid(uid).addAttribute(new Attribute[]{new Name(uid.getUidValue())}).addAttribute("record.timestamp", new Object[]{record.timestamp()}).addAttribute("record.value", new Object[]{record.value()});
                    if (!headers.isEmpty()) {
                        object.addAttribute("record.headers", new Object[]{headers});
                    }
                    handler.handle(new LiveSyncDeltaBuilder().setObject(object.build()).build());
                }
                catch (Exception e) {
                    LOG.error((Throwable)e, "While processing {0}", new Object[]{record});
                }
            });
            consumer.commitSync();
        }
        catch (Exception e) {
            throw new ConnectorException("While polling events from " + this.getTopic(objectClass), (Throwable)e);
        }
    }

    static {
        SimpleModule pojoModule = new SimpleModule("KafkaConnectorModule", new Version(1, 0, 0, null, null, null));
        pojoModule.addSerializer(GuardedString.class, (JsonSerializer)new GuardedStringSerializer());
        pojoModule.addSerializer(Attribute.class, (JsonSerializer)new AttributeSerializer());
        pojoModule.addSerializer(SyncToken.class, (JsonSerializer)new SyncTokenSerializer());
        pojoModule.addDeserializer(GuardedString.class, (JsonDeserializer)new GuardedStringDeserializer());
        pojoModule.addDeserializer(Attribute.class, (JsonDeserializer)new AttributeDeserializer());
        pojoModule.addDeserializer(SyncToken.class, (JsonDeserializer)new SyncTokenDeserializer());
        pojoModule.addDeserializer(ConnectorObject.class, (JsonDeserializer)new ConnectorObjectDeserializer());
        pojoModule.addDeserializer(SyncDelta.class, (JsonDeserializer)new SyncDeltaJacksonDeserializer());
        MAPPER = (JsonMapper)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)JsonMapper.builder().addModule((Module)pojoModule)).addModule((Module)new JavaTimeModule())).disable(new SerializationFeature[]{SerializationFeature.WRITE_DATES_AS_TIMESTAMPS})).visibility(PropertyAccessor.ALL, JsonAutoDetect.Visibility.NONE)).visibility(PropertyAccessor.FIELD, JsonAutoDetect.Visibility.ANY)).build();
    }
}

