/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.eventregistry.impl.persistence.deploy;

import java.util.List;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.api.FlowableObjectNotFoundException;
import org.flowable.common.engine.impl.persistence.deploy.DeploymentCache;
import org.flowable.eventregistry.api.ChannelDefinition;
import org.flowable.eventregistry.api.ChannelModelProcessor;
import org.flowable.eventregistry.api.EventDefinition;
import org.flowable.eventregistry.impl.ChannelDefinitionQueryImpl;
import org.flowable.eventregistry.impl.EventDefinitionQueryImpl;
import org.flowable.eventregistry.impl.EventRegistryEngineConfiguration;
import org.flowable.eventregistry.impl.persistence.deploy.ChannelDefinitionCacheEntry;
import org.flowable.eventregistry.impl.persistence.deploy.Deployer;
import org.flowable.eventregistry.impl.persistence.deploy.EventDefinitionCacheEntry;
import org.flowable.eventregistry.impl.persistence.entity.ChannelDefinitionEntity;
import org.flowable.eventregistry.impl.persistence.entity.ChannelDefinitionEntityManager;
import org.flowable.eventregistry.impl.persistence.entity.EventDefinitionEntity;
import org.flowable.eventregistry.impl.persistence.entity.EventDefinitionEntityManager;
import org.flowable.eventregistry.impl.persistence.entity.EventDeploymentEntity;
import org.flowable.eventregistry.impl.persistence.entity.EventDeploymentEntityManager;
import org.flowable.eventregistry.impl.persistence.entity.EventResourceEntity;
import org.flowable.eventregistry.model.ChannelModel;
import org.flowable.eventregistry.model.InboundChannelModel;

public class EventDeploymentManager {
    protected EventRegistryEngineConfiguration engineConfig;
    protected DeploymentCache<EventDefinitionCacheEntry> eventDefinitionCache;
    protected DeploymentCache<ChannelDefinitionCacheEntry> channelDefinitionCache;
    protected List<Deployer> deployers;
    protected EventDefinitionEntityManager eventDefinitionEntityManager;
    protected ChannelDefinitionEntityManager channelDefinitionEntityManager;
    protected EventDeploymentEntityManager deploymentEntityManager;

    public EventDeploymentManager(DeploymentCache<EventDefinitionCacheEntry> eventDefinitionCache, DeploymentCache<ChannelDefinitionCacheEntry> channelDefinitionCache, EventRegistryEngineConfiguration engineConfig) {
        this.eventDefinitionCache = eventDefinitionCache;
        this.channelDefinitionCache = channelDefinitionCache;
        this.engineConfig = engineConfig;
    }

    public void deploy(EventDeploymentEntity deployment) {
        for (Deployer deployer : this.deployers) {
            deployer.deploy(deployment);
        }
    }

    public EventDefinitionEntity findDeployedEventDefinitionById(String eventDefinitionId) {
        EventDefinitionEntity eventDefinition;
        if (eventDefinitionId == null) {
            throw new FlowableException("Invalid event definition id : null");
        }
        EventDefinitionCacheEntry cacheEntry = (EventDefinitionCacheEntry)this.eventDefinitionCache.get(eventDefinitionId);
        EventDefinitionEntity eventDefinitionEntity = eventDefinition = cacheEntry != null ? cacheEntry.getEventDefinitionEntity() : null;
        if (eventDefinition == null) {
            eventDefinition = (EventDefinitionEntity)this.engineConfig.getEventDefinitionEntityManager().findById(eventDefinitionId);
            if (eventDefinition == null) {
                throw new FlowableObjectNotFoundException("no deployed event definition found with id '" + eventDefinitionId + "'");
            }
            eventDefinition = this.resolveEventDefinition(eventDefinition).getEventDefinitionEntity();
        }
        return eventDefinition;
    }

    public ChannelDefinitionEntity findDeployedChannelDefinitionById(String channelDefinitionId) {
        ChannelDefinitionEntity channelDefinition;
        if (channelDefinitionId == null) {
            throw new FlowableException("Invalid channel definition id : null");
        }
        ChannelDefinitionCacheEntry cacheEntry = (ChannelDefinitionCacheEntry)this.channelDefinitionCache.get(channelDefinitionId);
        ChannelDefinitionEntity channelDefinitionEntity = channelDefinition = cacheEntry != null ? cacheEntry.getChannelDefinitionEntity() : null;
        if (channelDefinition == null) {
            channelDefinition = (ChannelDefinitionEntity)this.engineConfig.getChannelDefinitionEntityManager().findById(channelDefinitionId);
            if (channelDefinition == null) {
                throw new FlowableObjectNotFoundException("no deployed channel definition found with id '" + channelDefinitionId + "'");
            }
            channelDefinition = this.resolveChannelDefinition(channelDefinition).getChannelDefinitionEntity();
        }
        return channelDefinition;
    }

    public EventDefinitionEntity findDeployedLatestEventDefinitionByKey(String eventDefinitionKey) {
        EventDefinitionEntity eventDefinition = this.eventDefinitionEntityManager.findLatestEventDefinitionByKey(eventDefinitionKey);
        if (eventDefinition == null) {
            throw new FlowableObjectNotFoundException("no event definitions deployed with key '" + eventDefinitionKey + "'");
        }
        eventDefinition = this.resolveEventDefinition(eventDefinition).getEventDefinitionEntity();
        return eventDefinition;
    }

    public ChannelDefinitionEntity findDeployedLatestChannelDefinitionByKey(String channelDefinitionKey) {
        ChannelDefinitionEntity channelDefinition = this.channelDefinitionEntityManager.findLatestChannelDefinitionByKey(channelDefinitionKey);
        if (channelDefinition == null) {
            throw new FlowableObjectNotFoundException("no channel definitions deployed with key '" + channelDefinitionKey + "'");
        }
        channelDefinition = this.resolveChannelDefinition(channelDefinition).getChannelDefinitionEntity();
        return channelDefinition;
    }

    public EventDefinitionEntity findDeployedLatestEventDefinitionByKeyAndTenantId(String eventDefinitionKey, String tenantId) {
        EventDefinitionEntity eventDefinition = this.eventDefinitionEntityManager.findLatestEventDefinitionByKeyAndTenantId(eventDefinitionKey, tenantId);
        if (eventDefinition == null) {
            throw new FlowableObjectNotFoundException("no event definitions deployed with key '" + eventDefinitionKey + "' for tenant identifier '" + tenantId + "'");
        }
        eventDefinition = this.resolveEventDefinition(eventDefinition).getEventDefinitionEntity();
        return eventDefinition;
    }

    public EventDefinitionEntity findDeployedLatestEventDefinitionByKeyAndDeploymentId(String eventDefinitionKey, String deploymentId) {
        EventDefinitionEntity eventDefinition = this.eventDefinitionEntityManager.findEventDefinitionByDeploymentAndKey(deploymentId, eventDefinitionKey);
        if (eventDefinition == null) {
            throw new FlowableObjectNotFoundException("no event definitions deployed with key '" + eventDefinitionKey + "' for deployment id '" + deploymentId + "'");
        }
        eventDefinition = this.resolveEventDefinition(eventDefinition).getEventDefinitionEntity();
        return eventDefinition;
    }

    public EventDefinitionEntity findDeployedLatestEventDefinitionByKeyDeploymentIdAndTenantId(String eventDefinitionKey, String deploymentId, String tenantId) {
        EventDefinitionEntity eventDefinition = this.eventDefinitionEntityManager.findEventDefinitionByDeploymentAndKeyAndTenantId(deploymentId, eventDefinitionKey, tenantId);
        if (eventDefinition == null) {
            throw new FlowableObjectNotFoundException("no event definitions deployed with key '" + eventDefinitionKey + "' for deployment id '" + deploymentId + "' and tenant identifier '" + tenantId + "'");
        }
        eventDefinition = this.resolveEventDefinition(eventDefinition).getEventDefinitionEntity();
        return eventDefinition;
    }

    public EventDefinitionEntity findDeployedEventDefinitionByKeyAndVersionAndTenantId(String eventDefinitionKey, int eventVersion, String tenantId) {
        EventDefinitionEntity eventDefinition = this.eventDefinitionEntityManager.findEventDefinitionByKeyAndVersionAndTenantId(eventDefinitionKey, eventVersion, tenantId);
        if (eventDefinition == null) {
            throw new FlowableObjectNotFoundException("no event definitions deployed with key = '" + eventDefinitionKey + "'");
        }
        eventDefinition = this.resolveEventDefinition(eventDefinition).getEventDefinitionEntity();
        return eventDefinition;
    }

    public EventDefinitionCacheEntry resolveEventDefinition(EventDefinition eventDefinition) {
        String eventDefinitionId = eventDefinition.getId();
        String deploymentId = eventDefinition.getDeploymentId();
        EventDefinitionCacheEntry cachedEventDefinition = (EventDefinitionCacheEntry)this.eventDefinitionCache.get(eventDefinitionId);
        if (cachedEventDefinition == null) {
            EventDeploymentEntity deployment = (EventDeploymentEntity)this.engineConfig.getDeploymentEntityManager().findById(deploymentId);
            List<EventResourceEntity> resources = this.engineConfig.getResourceEntityManager().findResourcesByDeploymentId(deploymentId);
            for (EventResourceEntity resource : resources) {
                deployment.addResource(resource);
            }
            deployment.setNew(false);
            this.deploy(deployment);
            cachedEventDefinition = (EventDefinitionCacheEntry)this.eventDefinitionCache.get(eventDefinitionId);
            if (cachedEventDefinition == null) {
                throw new FlowableException("deployment '" + deploymentId + "' didn't put event definition '" + eventDefinitionId + "' in the cache");
            }
        }
        return cachedEventDefinition;
    }

    public ChannelDefinitionCacheEntry resolveChannelDefinition(ChannelDefinition channelDefinition) {
        String channelDefinitionId = channelDefinition.getId();
        String deploymentId = channelDefinition.getDeploymentId();
        ChannelDefinitionCacheEntry cachedChannelDefinition = (ChannelDefinitionCacheEntry)this.channelDefinitionCache.get(channelDefinitionId);
        if (cachedChannelDefinition == null) {
            EventDeploymentEntity deployment = (EventDeploymentEntity)this.engineConfig.getDeploymentEntityManager().findById(deploymentId);
            List<EventResourceEntity> resources = this.engineConfig.getResourceEntityManager().findResourcesByDeploymentId(deploymentId);
            for (EventResourceEntity resource : resources) {
                deployment.addResource(resource);
            }
            deployment.setNew(false);
            this.deploy(deployment);
            cachedChannelDefinition = (ChannelDefinitionCacheEntry)this.channelDefinitionCache.get(channelDefinitionId);
            if (cachedChannelDefinition == null) {
                throw new FlowableException("deployment '" + deploymentId + "' didn't put channel definition '" + channelDefinitionId + "' in the cache");
            }
        }
        return cachedChannelDefinition;
    }

    public void removeDeployment(String deploymentId) {
        EventDeploymentEntity deployment = (EventDeploymentEntity)this.deploymentEntityManager.findById(deploymentId);
        if (deployment == null) {
            throw new FlowableObjectNotFoundException("Could not find a deployment with id '" + deploymentId + "'.");
        }
        List eventDefinitions = new EventDefinitionQueryImpl().deploymentId(deploymentId).list();
        List channelDefinitions = new ChannelDefinitionQueryImpl().deploymentId(deploymentId).list();
        this.deploymentEntityManager.deleteDeployment(deploymentId);
        for (EventDefinition eventDefinition : eventDefinitions) {
            this.eventDefinitionCache.remove(eventDefinition.getId());
        }
        for (ChannelDefinition channelDefinition : channelDefinitions) {
            this.removeChannelDefinitionFromCache(channelDefinition);
        }
    }

    public void removeChannelDefinitionFromCache(ChannelDefinition channelDefinition) {
        this.removeChannelDefinitionFromCache(channelDefinition.getId());
    }

    public ChannelDefinition removeChannelDefinitionFromCache(String channelDefinitionId) {
        ChannelDefinitionCacheEntry cacheEntry = (ChannelDefinitionCacheEntry)this.channelDefinitionCache.get(channelDefinitionId);
        ChannelDefinitionEntity channelDefinition = null;
        if (cacheEntry != null) {
            channelDefinition = cacheEntry.getChannelDefinitionEntity();
            ChannelModel channelModel = cacheEntry.getChannelModel();
            for (ChannelModelProcessor channelModelProcessor : this.engineConfig.getChannelModelProcessors()) {
                if (!channelModelProcessor.canProcess(channelModel)) continue;
                if (channelModel instanceof InboundChannelModel) {
                    this.engineConfig.getInboundChannelModelCacheManager().unregisterChannelModel((InboundChannelModel)channelModel, (ChannelDefinition)channelDefinition);
                }
                channelModelProcessor.unregisterChannelModel(channelModel, channelDefinition.getTenantId(), this.engineConfig.getEventRepositoryService());
            }
        }
        this.channelDefinitionCache.remove(channelDefinitionId);
        return channelDefinition;
    }

    public List<Deployer> getDeployers() {
        return this.deployers;
    }

    public void setDeployers(List<Deployer> deployers) {
        this.deployers = deployers;
    }

    public DeploymentCache<EventDefinitionCacheEntry> getEventDefinitionCache() {
        return this.eventDefinitionCache;
    }

    public void setEventDefinitionCache(DeploymentCache<EventDefinitionCacheEntry> eventDefinitionCache) {
        this.eventDefinitionCache = eventDefinitionCache;
    }

    public DeploymentCache<ChannelDefinitionCacheEntry> getChannelDefinitionCache() {
        return this.channelDefinitionCache;
    }

    public void setChannelDefinitionCache(DeploymentCache<ChannelDefinitionCacheEntry> channelDefinitionCache) {
        this.channelDefinitionCache = channelDefinitionCache;
    }

    public EventDefinitionEntityManager getEventDefinitionEntityManager() {
        return this.eventDefinitionEntityManager;
    }

    public void setEventDefinitionEntityManager(EventDefinitionEntityManager eventDefinitionEntityManager) {
        this.eventDefinitionEntityManager = eventDefinitionEntityManager;
    }

    public ChannelDefinitionEntityManager getChannelDefinitionEntityManager() {
        return this.channelDefinitionEntityManager;
    }

    public void setChannelDefinitionEntityManager(ChannelDefinitionEntityManager channelDefinitionEntityManager) {
        this.channelDefinitionEntityManager = channelDefinitionEntityManager;
    }

    public EventDeploymentEntityManager getDeploymentEntityManager() {
        return this.deploymentEntityManager;
    }

    public void setDeploymentEntityManager(EventDeploymentEntityManager deploymentEntityManager) {
        this.deploymentEntityManager = deploymentEntityManager;
    }
}

