/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.delegate;

import java.util.HashMap;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.api.FlowableIllegalArgumentException;
import org.flowable.common.engine.api.variable.VariableContainer;
import org.flowable.common.engine.impl.el.VariableContainerWrapper;

public class BpmnError
extends FlowableException {
    private static final long serialVersionUID = 1L;
    private String errorCode;
    private VariableContainer additionalDataContainer;

    public BpmnError(String errorCode) {
        super("");
        this.setErrorCode(errorCode);
    }

    public BpmnError(String errorCode, String message) {
        super(message);
        this.setErrorCode(errorCode);
    }

    protected void setErrorCode(String errorCode) {
        if (errorCode == null) {
            throw new FlowableIllegalArgumentException("Error Code must not be null.");
        }
        if (errorCode.length() < 1) {
            throw new FlowableIllegalArgumentException("Error Code must not be empty.");
        }
        this.errorCode = errorCode;
    }

    public String getErrorCode() {
        return this.errorCode;
    }

    public VariableContainer getAdditionalDataContainer() {
        return this.additionalDataContainer;
    }

    public void setAdditionalDataContainer(VariableContainer additionalDataContainer) {
        this.additionalDataContainer = additionalDataContainer;
    }

    public void addAdditionalData(String name, Object value) {
        if (this.additionalDataContainer == null) {
            this.additionalDataContainer = new VariableContainerWrapper(new HashMap());
        }
        this.additionalDataContainer.setVariable(name, value);
    }
}

