/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.client.util;

import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.apereo.cas.client.Protocol;
import org.apereo.cas.client.proxy.ProxyGrantingTicketStorage;
import org.apereo.cas.client.util.CommonUtils;
import org.apereo.cas.client.util.URIBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class WebUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(WebUtils.class);
    private static final String PARAM_PROXY_GRANTING_TICKET_IOU = "pgtIou";
    private static final String PARAM_PROXY_GRANTING_TICKET = "pgtId";
    private static final String SERVICE_PARAMETER_NAMES;

    private WebUtils() {
    }

    public static void readAndRespondToProxyReceptorRequest(ServletRequest request, ServletResponse response, ProxyGrantingTicketStorage proxyGrantingTicketStorage) throws IOException {
        String proxyGrantingTicketIou = request.getParameter(PARAM_PROXY_GRANTING_TICKET_IOU);
        String proxyGrantingTicket = request.getParameter(PARAM_PROXY_GRANTING_TICKET);
        if (CommonUtils.isBlank(proxyGrantingTicket) || CommonUtils.isBlank(proxyGrantingTicketIou)) {
            response.getWriter().write("");
            return;
        }
        LOGGER.debug("Received proxyGrantingTicketId [{}] for proxyGrantingTicketIou [{}]", (Object)proxyGrantingTicket, (Object)proxyGrantingTicketIou);
        proxyGrantingTicketStorage.save(proxyGrantingTicketIou, proxyGrantingTicket);
        LOGGER.debug("Successfully saved proxyGrantingTicketId [{}] for proxyGrantingTicketIou [{}]", (Object)proxyGrantingTicket, (Object)proxyGrantingTicketIou);
        response.getWriter().write("<?xml version=\"1.0\"?>");
        response.getWriter().write("<casClient:proxySuccess xmlns:casClient=\"http://www.yale.edu/tp/casClient\" />");
    }

    private static String findMatchingServerName(HttpServletRequest request, String serverName) {
        String comparisonHost;
        String[] serverNames = serverName.split(" ");
        if (serverNames.length == 0 || serverNames.length == 1) {
            return serverName;
        }
        String host = request.getHeader("Host");
        String xHost = request.getHeader("X-Forwarded-Host");
        String string = comparisonHost = xHost != null ? xHost : host;
        if (comparisonHost == null) {
            return serverName;
        }
        for (String server : serverNames) {
            String lowerCaseServer = server.toLowerCase();
            if (!lowerCaseServer.contains(comparisonHost)) continue;
            return server;
        }
        return serverNames[0];
    }

    private static boolean requestIsOnStandardPort(ServletRequest request) {
        int serverPort = request.getServerPort();
        return serverPort == 80 || serverPort == 443;
    }

    @Deprecated
    public static String constructServiceUrl(HttpServletRequest request, HttpServletResponse response, String service, String serverNames, String artifactParameterName, boolean encode) {
        return WebUtils.constructServiceUrl(request, response, service, serverNames, SERVICE_PARAMETER_NAMES, artifactParameterName, encode);
    }

    public static String constructServiceUrl(HttpServletRequest request, HttpServletResponse response, String service, String serverNames, String serviceParameterName, String artifactParameterName, boolean encode) {
        URIBuilder builder;
        if (CommonUtils.isNotBlank(service)) {
            return encode ? response.encodeURL(service) : service;
        }
        String serverName = WebUtils.findMatchingServerName(request, serverNames);
        URIBuilder originalRequestUrl = new URIBuilder(request.getRequestURL().toString(), encode);
        originalRequestUrl.setParameters(request.getQueryString());
        if (!serverName.startsWith("https://") && !serverName.startsWith("http://")) {
            String scheme = request.isSecure() ? "https://" : "http://";
            builder = new URIBuilder(scheme + serverName, encode);
        } else {
            builder = new URIBuilder(serverName, encode);
        }
        if (builder.getPort() == -1 && !WebUtils.requestIsOnStandardPort((ServletRequest)request)) {
            builder.setPort(request.getServerPort());
        }
        builder.setEncodedPath(builder.getEncodedPath() + request.getRequestURI());
        List<String> serviceParameterNames = Arrays.asList(serviceParameterName.split(","));
        if (!serviceParameterNames.isEmpty() && !originalRequestUrl.getQueryParams().isEmpty()) {
            for (URIBuilder.BasicNameValuePair pair : originalRequestUrl.getQueryParams()) {
                String name = pair.name();
                if (name.equals(artifactParameterName) || serviceParameterNames.contains(name)) continue;
                if (name.contains("&") || name.contains("=")) {
                    URIBuilder encodedParamBuilder = new URIBuilder();
                    encodedParamBuilder.setParameters(name);
                    for (URIBuilder.BasicNameValuePair pair2 : encodedParamBuilder.getQueryParams()) {
                        String name2 = pair2.name();
                        if (name2.equals(artifactParameterName) || serviceParameterNames.contains(name2)) continue;
                        builder.addParameter(name2, pair2.value());
                    }
                    continue;
                }
                builder.addParameter(name, pair.value());
            }
        }
        String result = builder.toString();
        String returnValue = encode ? response.encodeURL(result) : result;
        LOGGER.debug("serviceUrl generated: {}", (Object)returnValue);
        return returnValue;
    }

    public static String safeGetParameter(HttpServletRequest request, String parameter, Collection<String> parameters) {
        if ("POST".equals(request.getMethod()) && parameters.contains(parameter)) {
            LOGGER.debug("safeGetParameter called on a POST HttpServletRequest for Restricted Parameters.  Cannot complete check safely.  Reverting to standard behavior for this Parameter");
            return request.getParameter(parameter);
        }
        return request.getQueryString() == null || !request.getQueryString().contains(parameter) ? null : request.getParameter(parameter);
    }

    public static String safeGetParameter(HttpServletRequest request, String parameter) {
        return WebUtils.safeGetParameter(request, parameter, List.of("logoutRequest"));
    }

    public static void sendRedirect(HttpServletResponse response, String url) {
        try {
            response.sendRedirect(url);
        }
        catch (IOException e) {
            LOGGER.warn(e.getMessage(), (Throwable)e);
        }
    }

    static {
        HashSet<String> serviceParameterSet = new HashSet<String>(4);
        for (Protocol protocol : Protocol.values()) {
            serviceParameterSet.add(protocol.getServiceParameterName());
        }
        SERVICE_PARAMETER_NAMES = ((Object)serviceParameterSet).toString().replaceAll("\\[|\\]", "").replaceAll("\\s", "");
    }
}

