/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.metadata.resolver.filter.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.saml.metadata.resolver.filter.AbstractMetadataFilter;
import org.opensaml.saml.metadata.resolver.filter.FilterException;
import org.opensaml.saml.metadata.resolver.filter.MetadataFilterContext;
import org.opensaml.saml.saml2.metadata.EntitiesDescriptor;
import org.opensaml.saml.saml2.metadata.EntityDescriptor;
import org.slf4j.Logger;

public class PredicateFilter
extends AbstractMetadataFilter {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(PredicateFilter.class);
    @Nonnull
    private final Direction direction;
    @Nonnull
    private final Predicate<EntityDescriptor> condition;
    private boolean removeEmptyEntitiesDescriptors;

    public PredicateFilter(@Nonnull Direction dir, @Nonnull Predicate<EntityDescriptor> theCondition) {
        this.condition = (Predicate)Constraint.isNotNull(theCondition, (String)"Matching condition cannot be null");
        this.direction = (Direction)((Object)Constraint.isNotNull((Object)((Object)dir), (String)"Direction cannot be null"));
        this.removeEmptyEntitiesDescriptors = true;
    }

    @Nonnull
    public Direction getDirection() {
        return this.direction;
    }

    @Nonnull
    public Predicate<EntityDescriptor> getCondition() {
        return this.condition;
    }

    public boolean getRemoveEmptyEntitiesDescriptors() {
        return this.removeEmptyEntitiesDescriptors;
    }

    public void setRemoveEmptyEntitiesDescriptors(boolean remove) {
        this.checkSetterPreconditions();
        this.removeEmptyEntitiesDescriptors = remove;
    }

    @Nullable
    public XMLObject filter(@Nullable XMLObject metadata, @Nonnull MetadataFilterContext context) throws FilterException {
        this.checkComponentActive();
        if (metadata == null) {
            return null;
        }
        if (metadata instanceof EntitiesDescriptor) {
            this.filterEntitiesDescriptor((EntitiesDescriptor)metadata);
            return metadata;
        }
        if (metadata instanceof EntityDescriptor) {
            EntityDescriptor entity = (EntityDescriptor)metadata;
            if (Direction.EXCLUDE.equals((Object)this.direction) == this.condition.test(entity)) {
                this.log.trace("Filtering out entity {} ", (Object)entity.getEntityID());
                return null;
            }
            return metadata;
        }
        this.log.error("Unrecognised metadata type {}", (Object)metadata.getClass().getSimpleName());
        return null;
    }

    protected void filterEntitiesDescriptor(@Nonnull EntitiesDescriptor descriptor) {
        List entitiesDescriptors;
        List entityDescriptors = descriptor.getEntityDescriptors();
        if (!entityDescriptors.isEmpty()) {
            ArrayList<EntityDescriptor> emptyEntityDescriptors = new ArrayList<EntityDescriptor>();
            for (EntityDescriptor entityDescriptor : entityDescriptors) {
                if (Direction.EXCLUDE.equals((Object)this.direction) != this.condition.test(entityDescriptor)) continue;
                this.log.trace("Filtering out entity {} from group {}", (Object)entityDescriptor.getEntityID(), (Object)descriptor.getName());
                emptyEntityDescriptors.add(entityDescriptor);
            }
            entityDescriptors.removeAll(emptyEntityDescriptors);
        }
        if (!(entitiesDescriptors = descriptor.getEntitiesDescriptors()).isEmpty()) {
            ArrayList<EntitiesDescriptor> emptyEntitiesDescriptors = new ArrayList<EntitiesDescriptor>();
            for (EntitiesDescriptor entitiesDescriptor : entitiesDescriptors) {
                assert (entitiesDescriptor != null);
                this.filterEntitiesDescriptor(entitiesDescriptor);
                if (!this.getRemoveEmptyEntitiesDescriptors() || !entitiesDescriptor.getEntityDescriptors().isEmpty() || !entitiesDescriptor.getEntitiesDescriptors().isEmpty()) continue;
                this.log.trace("Filtering out empty group {} from group {}", (Object)entitiesDescriptor.getName(), (Object)descriptor.getName());
                emptyEntitiesDescriptors.add(entitiesDescriptor);
            }
            entitiesDescriptors.removeAll(emptyEntitiesDescriptors);
        }
    }

    public static enum Direction {
        INCLUDE,
        EXCLUDE;

    }
}

