/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.provider.json.utils;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.staxutils.DelegatingXMLStreamWriter;
import org.apache.cxf.staxutils.DepthXMLStreamReader;
import org.apache.cxf.staxutils.DocumentDepthProperties;
import org.apache.cxf.staxutils.transform.IgnoreNamespacesWriter;
import org.codehaus.jettison.badgerfish.BadgerFishXMLInputFactory;
import org.codehaus.jettison.badgerfish.BadgerFishXMLOutputFactory;
import org.codehaus.jettison.json.JSONTokener;
import org.codehaus.jettison.mapped.Configuration;
import org.codehaus.jettison.mapped.MappedNamespaceConvention;
import org.codehaus.jettison.mapped.MappedXMLInputFactory;
import org.codehaus.jettison.mapped.MappedXMLStreamWriter;
import org.codehaus.jettison.mapped.TypeConverter;

public final class JSONUtils {
    public static final String XSI_PREFIX = "xsi";
    public static final String XSI_URI = "http://www.w3.org/2001/XMLSchema-instance";

    private JSONUtils() {
    }

    public static XMLStreamWriter createBadgerFishWriter(OutputStream os, String enc) throws XMLStreamException {
        BadgerFishXMLOutputFactory factory = new BadgerFishXMLOutputFactory();
        return factory.createXMLStreamWriter(os, enc);
    }

    public static XMLStreamReader createBadgerFishReader(InputStream is, String enc) throws XMLStreamException {
        BadgerFishXMLInputFactory factory = new BadgerFishXMLInputFactory();
        return factory.createXMLStreamReader(is, enc);
    }

    public static XMLStreamWriter createStreamWriter(OutputStream os, QName qname, boolean writeXsiType, Configuration config, boolean serializeAsArray, List<String> arrayKeys, boolean dropRootElement, String enc) throws Exception {
        MappedNamespaceConvention convention = new MappedNamespaceConvention(config);
        MappedXMLStreamWriter xsw = new MappedXMLStreamWriter(convention, (Writer)new OutputStreamWriter(os, enc));
        if (serializeAsArray) {
            if (arrayKeys != null) {
                for (String key : arrayKeys) {
                    xsw.serializeAsArray(key);
                }
            } else if (qname != null) {
                String key = JSONUtils.getKey(convention, qname);
                xsw.serializeAsArray(key);
            }
        }
        return !writeXsiType || dropRootElement ? new IgnoreContentJettisonWriter((XMLStreamWriter)xsw, writeXsiType, dropRootElement) : xsw;
    }

    public static Configuration createConfiguration(ConcurrentHashMap<String, String> namespaceMap, boolean writeXsiType, boolean attributesAsElements, TypeConverter converter) {
        if (writeXsiType) {
            namespaceMap.putIfAbsent(XSI_URI, XSI_PREFIX);
        }
        Configuration c = new Configuration(namespaceMap);
        c.setSupressAtAttributes(attributesAsElements);
        if (converter != null) {
            c.setTypeConverter(converter);
        }
        return c;
    }

    public static XMLStreamWriter createIgnoreMixedContentWriterIfNeeded(XMLStreamWriter writer, boolean ignoreMixedContent) {
        return ignoreMixedContent ? new IgnoreMixedContentWriter(writer) : writer;
    }

    public static XMLStreamWriter createIgnoreNsWriterIfNeeded(XMLStreamWriter writer, boolean ignoreNamespaces, boolean ignoreXsiAttributes) {
        return ignoreNamespaces ? new IgnoreNamespacesWriter(writer, ignoreXsiAttributes) : writer;
    }

    private static String getKey(MappedNamespaceConvention convention, QName qname) throws Exception {
        return convention.createKey(qname.getPrefix(), qname.getNamespaceURI(), qname.getLocalPart());
    }

    public static XMLStreamReader createStreamReader(InputStream is, boolean readXsiType, ConcurrentHashMap<String, String> namespaceMap) throws Exception {
        return JSONUtils.createStreamReader(is, readXsiType, namespaceMap, null, null, null, StandardCharsets.UTF_8.name());
    }

    public static XMLStreamReader createStreamReader(InputStream is, boolean readXsiType, ConcurrentHashMap<String, String> namespaceMap, String namespaceSeparator, List<String> primitiveArrayKeys, DocumentDepthProperties depthProps, String enc) throws Exception {
        if (readXsiType) {
            namespaceMap.putIfAbsent(XSI_URI, XSI_PREFIX);
        }
        Configuration conf = new Configuration(namespaceMap);
        if (namespaceSeparator != null) {
            conf.setJsonNamespaceSeparator(namespaceSeparator);
        }
        if (primitiveArrayKeys != null) {
            conf.setPrimitiveArrayKeys(new HashSet<String>(primitiveArrayKeys));
        }
        JettisonMappedReaderFactory factory = depthProps != null ? new JettisonMappedReaderFactory(conf, depthProps) : new MappedXMLInputFactory(conf);
        return new JettisonReader(namespaceMap, ((XMLInputFactory)((Object)factory)).createXMLStreamReader(is, enc));
    }

    private static class IgnoreContentJettisonWriter
    extends DelegatingXMLStreamWriter {
        private boolean writeXsiType;
        private boolean dropRootElement;
        private boolean rootDropped;
        private int index;

        IgnoreContentJettisonWriter(XMLStreamWriter writer, boolean writeXsiType, boolean dropRootElement) {
            super(writer);
            this.writeXsiType = writeXsiType;
            this.dropRootElement = dropRootElement;
        }

        public void writeAttribute(String prefix, String uri, String local, String value) throws XMLStreamException {
            if (!this.writeXsiType && JSONUtils.XSI_PREFIX.equals(prefix) && ("type".equals(local) || "nil".equals(local))) {
                return;
            }
            super.writeAttribute(prefix, uri, local, value);
        }

        public void writeStartElement(String prefix, String local, String uri) throws XMLStreamException {
            ++this.index;
            if (this.dropRootElement && this.index - 1 == 0) {
                this.rootDropped = true;
                return;
            }
            super.writeStartElement(prefix, local, uri);
        }

        public void writeStartElement(String local) throws XMLStreamException {
            this.writeStartElement("", local, "");
        }

        public void writeEndElement() throws XMLStreamException {
            --this.index;
            if (this.rootDropped && this.index == 0) {
                return;
            }
            super.writeEndElement();
        }
    }

    private static class IgnoreMixedContentWriter
    extends DelegatingXMLStreamWriter {
        String lastText;
        boolean isMixed;
        List<Boolean> mixed = new LinkedList<Boolean>();

        IgnoreMixedContentWriter(XMLStreamWriter writer) {
            super(writer);
        }

        public void writeCharacters(String text) throws XMLStreamException {
            if (StringUtils.isEmpty((String)text.trim())) {
                this.lastText = text;
            } else if (this.lastText != null) {
                this.lastText = this.lastText + text;
            } else if (!this.isMixed) {
                super.writeCharacters(text);
            } else {
                this.lastText = text;
            }
        }

        public void writeStartElement(String prefix, String local, String uri) throws XMLStreamException {
            if (this.lastText != null) {
                this.isMixed = true;
            }
            this.mixed.add(0, this.isMixed);
            this.lastText = null;
            this.isMixed = false;
            super.writeStartElement(prefix, local, uri);
        }

        public void writeStartElement(String uri, String local) throws XMLStreamException {
            if (this.lastText != null) {
                this.isMixed = true;
            }
            this.mixed.add(0, this.isMixed);
            this.lastText = null;
            this.isMixed = false;
            super.writeStartElement(uri, local);
        }

        public void writeStartElement(String local) throws XMLStreamException {
            if (this.lastText != null) {
                this.isMixed = true;
            }
            this.mixed.add(0, this.isMixed);
            this.lastText = null;
            this.isMixed = false;
            super.writeStartElement(local);
        }

        public void writeEndElement() throws XMLStreamException {
            if (!(this.lastText == null || this.isMixed && StringUtils.isEmpty((String)this.lastText.trim()))) {
                super.writeCharacters(this.lastText.trim());
            }
            super.writeEndElement();
            this.isMixed = this.mixed.get(0);
            this.mixed.remove(0);
        }
    }

    private static class JettisonMappedReaderFactory
    extends MappedXMLInputFactory {
        private DocumentDepthProperties depthProps;

        JettisonMappedReaderFactory(Configuration conf, DocumentDepthProperties depthProps) {
            super(conf);
            this.depthProps = depthProps;
        }

        protected JSONTokener createNewJSONTokener(String doc) {
            return new JSONTokener(doc, this.depthProps.getInnerElementCountThreshold());
        }
    }

    private static class JettisonReader
    extends DepthXMLStreamReader {
        private Map<String, String> namespaceMap;

        JettisonReader(Map<String, String> nsMap, XMLStreamReader reader) {
            super(reader);
            this.namespaceMap = nsMap;
        }

        public String getNamespaceURI(String arg0) {
            String uri = super.getNamespaceURI(arg0);
            if (uri == null) {
                uri = this.getNamespaceContext().getNamespaceURI(arg0);
            }
            return uri;
        }

        public String getAttributePrefix(int n) {
            QName name = this.getAttributeName(n);
            if (name != null && JSONUtils.XSI_URI.equals(name.getNamespaceURI())) {
                return JSONUtils.XSI_PREFIX;
            }
            return super.getAttributePrefix(n);
        }

        public NamespaceContext getNamespaceContext() {
            return new NamespaceContext(){

                @Override
                public String getNamespaceURI(String prefix) {
                    for (Map.Entry<String, String> entry : namespaceMap.entrySet()) {
                        if (!entry.getValue().equals(prefix)) continue;
                        return entry.getKey();
                    }
                    return null;
                }

                @Override
                public String getPrefix(String ns) {
                    return namespaceMap.get(ns);
                }

                @Override
                public Iterator<String> getPrefixes(String ns) {
                    String prefix = this.getPrefix(ns);
                    return prefix == null ? null : Collections.singletonList(prefix).iterator();
                }
            };
        }
    }
}

