/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bval.jsr;

import jakarta.validation.BootstrapConfiguration;
import jakarta.validation.executable.ExecutableType;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import org.apache.bval.jsr.util.ExecutableTypes;

public class BootstrapConfigurationImpl
implements BootstrapConfiguration {
    public static final BootstrapConfigurationImpl DEFAULT = new BootstrapConfigurationImpl(Collections.emptySet(), true, EnumSet.of(ExecutableType.IMPLICIT), Collections.emptyMap(), Collections.emptySet());
    private final Set<String> constraintMappingResourcePaths;
    private final boolean executableValidationEnabled;
    private final Set<ExecutableType> defaultValidatedExecutableTypes;
    private final Map<String, String> properties;
    private final Set<String> valueExtractorClassNames;
    private String parameterNameProviderClassName;
    private String traversableResolverClassName;
    private String messageInterpolatorClassName;
    private String constraintValidatorFactoryClassName;
    private String defaultProviderClassName;
    private String clockProviderClassName;

    public BootstrapConfigurationImpl(String defaultProviderClassName, String constraintValidatorFactoryClassName, String messageInterpolatorClassName, String traversableResolverClassName, String parameterNameProviderClassName, Set<String> constraintMappingResourcePaths, boolean executableValidationEnabled, Set<ExecutableType> defaultValidatedExecutableTypes, Map<String, String> properties, String clockProviderClassName, Set<String> valueExtractorClassNames) {
        this(Collections.unmodifiableSet(constraintMappingResourcePaths), executableValidationEnabled, defaultValidatedExecutableTypes, Collections.unmodifiableMap(properties), Collections.unmodifiableSet(valueExtractorClassNames));
        this.parameterNameProviderClassName = parameterNameProviderClassName;
        this.traversableResolverClassName = traversableResolverClassName;
        this.messageInterpolatorClassName = messageInterpolatorClassName;
        this.constraintValidatorFactoryClassName = constraintValidatorFactoryClassName;
        this.defaultProviderClassName = defaultProviderClassName;
        this.clockProviderClassName = clockProviderClassName;
    }

    private BootstrapConfigurationImpl(Set<String> constraintMappingResourcePaths, boolean executableValidationEnabled, Set<ExecutableType> defaultValidatedExecutableTypes, Map<String, String> properties, Set<String> valueExtractorClassNames) {
        this.constraintMappingResourcePaths = constraintMappingResourcePaths;
        this.executableValidationEnabled = executableValidationEnabled;
        this.defaultValidatedExecutableTypes = ExecutableTypes.interpret(defaultValidatedExecutableTypes);
        this.properties = properties;
        this.valueExtractorClassNames = valueExtractorClassNames;
    }

    public String getDefaultProviderClassName() {
        return this.defaultProviderClassName;
    }

    public String getConstraintValidatorFactoryClassName() {
        return this.constraintValidatorFactoryClassName;
    }

    public String getMessageInterpolatorClassName() {
        return this.messageInterpolatorClassName;
    }

    public String getTraversableResolverClassName() {
        return this.traversableResolverClassName;
    }

    public String getParameterNameProviderClassName() {
        return this.parameterNameProviderClassName;
    }

    public Set<String> getConstraintMappingResourcePaths() {
        return Collections.unmodifiableSet(this.constraintMappingResourcePaths);
    }

    public boolean isExecutableValidationEnabled() {
        return this.executableValidationEnabled;
    }

    public Set<ExecutableType> getDefaultValidatedExecutableTypes() {
        return Collections.unmodifiableSet(this.defaultValidatedExecutableTypes);
    }

    public Map<String, String> getProperties() {
        return Collections.unmodifiableMap(this.properties);
    }

    public String getClockProviderClassName() {
        return this.clockProviderClassName;
    }

    public Set<String> getValueExtractorClassNames() {
        return Collections.unmodifiableSet(this.valueExtractorClassNames);
    }
}

