/*
 * Decompiled with CFR 0.152.
 */
package jakarta.faces.event;

import jakarta.faces.FacesException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.myfaces.core.api.shared.lang.Assert;

public class PhaseId
implements Comparable {
    public static final PhaseId ANY_PHASE;
    public static final PhaseId APPLY_REQUEST_VALUES;
    public static final PhaseId INVOKE_APPLICATION;
    public static final PhaseId PROCESS_VALIDATIONS;
    public static final PhaseId RENDER_RESPONSE;
    public static final PhaseId RESTORE_VIEW;
    public static final PhaseId UPDATE_MODEL_VALUES;
    public static final List<PhaseId> VALUES;
    private final String _name;
    private final int _ordinal;

    private PhaseId(String name, int ordinal) {
        this._name = name;
        this._ordinal = ordinal;
    }

    public int compareTo(Object other) {
        return this._ordinal - ((PhaseId)other)._ordinal;
    }

    public int getOrdinal() {
        return this._ordinal;
    }

    public String toString() {
        return this._name + "(" + this._ordinal + ")";
    }

    public String getName() {
        return this._name;
    }

    public static PhaseId phaseIdValueOf(String phase) {
        Assert.notNull(phase, "phase");
        for (int i = 0; i < VALUES.size(); ++i) {
            PhaseId phaseId = VALUES.get(i);
            if (!phaseId.getName().equals(phase)) continue;
            return phaseId;
        }
        throw new FacesException("Phase " + phase + " is invalid");
    }

    static {
        int i = 0;
        ArrayList<PhaseId> list = new ArrayList<PhaseId>(6);
        ANY_PHASE = new PhaseId("ANY_PHASE", i++);
        list.add(ANY_PHASE);
        RESTORE_VIEW = new PhaseId("RESTORE_VIEW", i++);
        list.add(RESTORE_VIEW);
        APPLY_REQUEST_VALUES = new PhaseId("APPLY_REQUEST_VALUES", i++);
        list.add(APPLY_REQUEST_VALUES);
        PROCESS_VALIDATIONS = new PhaseId("PROCESS_VALIDATIONS", i++);
        list.add(PROCESS_VALIDATIONS);
        UPDATE_MODEL_VALUES = new PhaseId("UPDATE_MODEL_VALUES", i++);
        list.add(UPDATE_MODEL_VALUES);
        INVOKE_APPLICATION = new PhaseId("INVOKE_APPLICATION", i++);
        list.add(INVOKE_APPLICATION);
        RENDER_RESPONSE = new PhaseId("RENDER_RESPONSE", i++);
        list.add(RENDER_RESPONSE);
        VALUES = Collections.unmodifiableList(list);
    }
}

