/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.cde.utils;

import java.io.File;
import java.io.FileReader;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.uima.internal.util.XMLUtils;
import org.apache.uima.ruta.cde.utils.ConstraintContentHandler;
import org.apache.uima.ruta.cde.utils.ConstraintData;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;

public class ConstraintXMLUtils {
    public static void writeConstraints(String location, List<ConstraintData> constraints) throws Exception {
        StringBuilder sb = new StringBuilder();
        sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        sb.append("\n");
        sb.append("<constraints>");
        sb.append("\n");
        for (ConstraintData eachConstraint : constraints) {
            sb.append(eachConstraint.toXML());
            sb.append("\n");
        }
        sb.append("</constraints>");
        FileUtils.writeStringToFile((File)new File(location), (String)sb.toString(), (String)"UTF-8");
    }

    public static List<ConstraintData> readConstraints(String location) throws Exception {
        try (FileReader reader = new FileReader(location);){
            InputSource inputSource = new InputSource(reader);
            ConstraintContentHandler handler = new ConstraintContentHandler();
            XMLReader xmlReader = XMLUtils.createXMLReader();
            xmlReader.setContentHandler(handler);
            xmlReader.parse(inputSource);
            List<ConstraintData> list = handler.getConstraints();
            return list;
        }
    }
}

