/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.sql.engine.exec.mapping;

import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import java.io.Serializable;
import java.util.List;
import org.apache.ignite3.internal.sql.engine.exec.mapping.ColocationGroup;
import org.apache.ignite3.internal.sql.engine.prepare.pruning.PartitionPruningMetadata;
import org.jetbrains.annotations.Nullable;

public class FragmentDescription
implements Serializable {
    private static final long serialVersionUID = 0L;
    private final long fragmentId;
    private final boolean prefetch;
    private final Long2ObjectMap<ColocationGroup> groupsBySourceId;
    @Nullable
    private final ColocationGroup target;
    @Nullable
    private final Long2ObjectMap<List<String>> sourcesByExchangeId;
    @Nullable
    private final PartitionPruningMetadata pruningMetadata;

    public FragmentDescription(long fragmentId, boolean prefetch, Long2ObjectMap<ColocationGroup> groupsBySourceId, @Nullable ColocationGroup target, @Nullable Long2ObjectMap<List<String>> sourcesByExchangeId, @Nullable PartitionPruningMetadata pruningMetadata) {
        this.fragmentId = fragmentId;
        this.prefetch = prefetch;
        this.groupsBySourceId = groupsBySourceId;
        this.target = target;
        this.sourcesByExchangeId = sourcesByExchangeId;
        this.pruningMetadata = pruningMetadata;
    }

    public boolean prefetch() {
        return this.prefetch;
    }

    public long fragmentId() {
        return this.fragmentId;
    }

    @Nullable
    public ColocationGroup target() {
        return this.target;
    }

    @Nullable
    public List<String> remotes(long exchangeId) {
        if (this.sourcesByExchangeId == null) {
            return null;
        }
        return (List)this.sourcesByExchangeId.get(exchangeId);
    }

    @Nullable
    public ColocationGroup group(long sourceId) {
        return (ColocationGroup)this.groupsBySourceId.get(sourceId);
    }

    @Nullable
    public PartitionPruningMetadata partitionPruningMetadata() {
        return this.pruningMetadata;
    }
}

