/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.raft.jraft.rpc;

import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.Objects;
import org.apache.ignite3.internal.network.serialization.MessageSerializer;
import org.apache.ignite3.internal.network.serialization.marshal.MarshalledObject;
import org.apache.ignite3.internal.network.serialization.marshal.UserObjectMarshaller;
import org.apache.ignite3.internal.tostring.IgniteToStringInclude;
import org.apache.ignite3.internal.tostring.S;
import org.apache.ignite3.raft.jraft.rpc.RpcRequests;
import org.apache.ignite3.raft.jraft.rpc.SMErrorResponseBuilder;
import org.apache.ignite3.raft.jraft.rpc.SMErrorResponseSerializer;
import org.apache.ignite3.raft.jraft.rpc.impl.SMThrowable;

public class SMErrorResponseImpl
implements RpcRequests.SMErrorResponse,
Cloneable {
    public static final short GROUP_TYPE = 3;
    public static final short TYPE = 3014;
    @IgniteToStringInclude
    private SMThrowable error;
    private byte[] errorByteArray;

    private SMErrorResponseImpl(SMThrowable error, byte[] errorByteArray) {
        if (error == null && errorByteArray == null) {
            throw new NullPointerException("error is not marked @Nullable");
        }
        this.error = error;
        this.errorByteArray = errorByteArray;
    }

    byte[] errorByteArray() {
        return this.errorByteArray;
    }

    @Override
    public SMThrowable error() {
        return this.error;
    }

    public MessageSerializer serializer() {
        return SMErrorResponseSerializer.INSTANCE;
    }

    @Override
    public short groupType() {
        return 3;
    }

    public String toString() {
        return S.toString(SMErrorResponseImpl.class, this);
    }

    @Override
    public short messageType() {
        return 3014;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        SMErrorResponseImpl otherMessage = (SMErrorResponseImpl)other;
        return Objects.equals(this.error, otherMessage.error);
    }

    public int hashCode() {
        int result = 0;
        result = Objects.hash(this.error);
        return result;
    }

    @Override
    public SMErrorResponseImpl clone() {
        try {
            return (SMErrorResponseImpl)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static SMErrorResponseBuilder builder() {
        return new Builder();
    }

    @Override
    public void prepareMarshal(IntSet usedDescriptors, Object marshallerObj) throws Exception {
        UserObjectMarshaller marshaller = (UserObjectMarshaller)marshallerObj;
        MarshalledObject errorByteArraymo = marshaller.marshal(this.error);
        usedDescriptors.addAll((IntCollection)errorByteArraymo.usedDescriptorIds());
        this.errorByteArray = errorByteArraymo.bytes();
    }

    @Override
    public void unmarshal(Object marshallerObj, Object descriptorsObj) throws Exception {
        UserObjectMarshaller marshaller = (UserObjectMarshaller)marshallerObj;
        this.error = (SMThrowable)marshaller.unmarshal(this.errorByteArray, descriptorsObj);
        this.errorByteArray = null;
    }

    private static class Builder
    implements SMErrorResponseBuilder {
        private SMThrowable error;
        private byte[] errorByteArray;

        private Builder() {
        }

        @Override
        public SMErrorResponseBuilder error(SMThrowable error) {
            Objects.requireNonNull(error, "error is not marked @Nullable");
            this.error = error;
            return this;
        }

        @Override
        public SMErrorResponseBuilder errorByteArray(byte[] errorByteArray) {
            this.errorByteArray = errorByteArray;
            return this;
        }

        @Override
        public SMThrowable error() {
            return this.error;
        }

        @Override
        public byte[] errorByteArray() {
            return this.errorByteArray;
        }

        @Override
        public RpcRequests.SMErrorResponse build() {
            return new SMErrorResponseImpl(this.error, this.errorByteArray);
        }
    }
}

