/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.test.junit;

import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.AbstractLifeCycle;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.Logger;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.LoggerContextAccessor;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.Configurator;
import org.apache.logging.log4j.core.selector.ContextSelector;
import org.apache.logging.log4j.core.test.appender.ListAppender;
import org.apache.logging.log4j.core.test.junit.CleanFiles;
import org.apache.logging.log4j.core.test.junit.CleanFolders;
import org.apache.logging.log4j.status.StatusLogger;
import org.junit.Assert;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public class LoggerContextRule
implements TestRule,
LoggerContextAccessor {
    private static final String SYS_PROP_KEY_CLASS_NAME = "org.apache.logging.log4j.junit.LoggerContextRule#ClassName";
    private static final String SYS_PROP_KEY_DISPLAY_NAME = "org.apache.logging.log4j.junit.LoggerContextRule#DisplayName";
    private final String configurationLocation;
    private LoggerContext loggerContext;
    private Class<? extends ContextSelector> contextSelectorClass;
    private String testClassName;
    private final long shutdownTimeout;
    private final TimeUnit shutdownTimeUnit;

    public static LoggerContextRule createShutdownTimeoutLoggerContextRule(String config) {
        return new LoggerContextRule(config, 10, TimeUnit.SECONDS);
    }

    public LoggerContextRule() {
        this(null, null);
    }

    public LoggerContextRule(String configurationLocation) {
        this(configurationLocation, null);
    }

    public LoggerContextRule(String configurationLocation, Class<? extends ContextSelector> contextSelectorClass) {
        this(configurationLocation, contextSelectorClass, 0L, AbstractLifeCycle.DEFAULT_STOP_TIMEUNIT);
    }

    public LoggerContextRule(String configurationLocation, Class<? extends ContextSelector> contextSelectorClass, long shutdownTimeout, TimeUnit shutdownTimeUnit) {
        this.configurationLocation = configurationLocation;
        this.contextSelectorClass = contextSelectorClass;
        this.shutdownTimeout = shutdownTimeout;
        this.shutdownTimeUnit = shutdownTimeUnit;
    }

    public LoggerContextRule(String configurationLocation, int shutdownTimeout, TimeUnit shutdownTimeUnit) {
        this(configurationLocation, null, shutdownTimeout, shutdownTimeUnit);
    }

    public Statement apply(final Statement base, final Description description) {
        if (System.getProperties().containsKey("EBUG")) {
            StatusLogger.getLogger().setLevel(Level.DEBUG);
        }
        this.testClassName = description.getClassName();
        return new Statement(){

            public void evaluate() throws Throwable {
                if (LoggerContextRule.this.contextSelectorClass != null) {
                    System.setProperty("Log4jContextSelector", LoggerContextRule.this.contextSelectorClass.getName());
                }
                System.setProperty(LoggerContextRule.SYS_PROP_KEY_CLASS_NAME, description.getClassName());
                System.setProperty(LoggerContextRule.SYS_PROP_KEY_DISPLAY_NAME, description.getDisplayName());
                LoggerContextRule.this.loggerContext = Configurator.initialize((String)description.getDisplayName(), (ClassLoader)description.getTestClass().getClassLoader(), (String)LoggerContextRule.this.configurationLocation);
                try {
                    base.evaluate();
                }
                finally {
                    if (!Configurator.shutdown((LoggerContext)LoggerContextRule.this.loggerContext, (long)LoggerContextRule.this.shutdownTimeout, (TimeUnit)LoggerContextRule.this.shutdownTimeUnit)) {
                        StatusLogger.getLogger().error("Logger context {} did not shutdown completely after {} {}.", (Object)LoggerContextRule.this.loggerContext.getName(), (Object)LoggerContextRule.this.shutdownTimeout, (Object)LoggerContextRule.this.shutdownTimeUnit);
                    }
                    LoggerContextRule.this.loggerContext = null;
                    LoggerContextRule.this.contextSelectorClass = null;
                    StatusLogger.getLogger().reset();
                    System.clearProperty("Log4jContextSelector");
                    System.clearProperty(LoggerContextRule.SYS_PROP_KEY_CLASS_NAME);
                    System.clearProperty(LoggerContextRule.SYS_PROP_KEY_DISPLAY_NAME);
                }
            }
        };
    }

    public <T extends Appender> T getAppender(String name) {
        return (T)((Appender)this.getConfiguration().getAppenders().get(name));
    }

    public <T extends Appender> T getAppender(String name, Class<T> cls) {
        return (T)((Appender)cls.cast(this.getConfiguration().getAppenders().get(name)));
    }

    public Configuration getConfiguration() {
        return this.loggerContext.getConfiguration();
    }

    public String getConfigurationLocation() {
        return this.configurationLocation;
    }

    public LoggerContext getLoggerContext() {
        return this.loggerContext;
    }

    public ListAppender getListAppender(String name) {
        Object appender = this.getAppender(name);
        if (appender instanceof ListAppender) {
            return (ListAppender)((Object)appender);
        }
        throw new AssertionError((Object)("No ListAppender named " + name + " found."));
    }

    public Logger getLogger() {
        return this.loggerContext.getLogger(this.testClassName);
    }

    public Logger getLogger(Class<?> clazz) {
        return this.loggerContext.getLogger(clazz.getName());
    }

    public Logger getLogger(String name) {
        return this.loggerContext.getLogger(name);
    }

    public Appender getRequiredAppender(String name) {
        Object appender = this.getAppender(name);
        Assert.assertNotNull((String)("Appender named " + name + " was null."), appender);
        return appender;
    }

    public <T extends Appender> T getRequiredAppender(String name, Class<T> cls) {
        T appender = this.getAppender(name, cls);
        Assert.assertNotNull((String)("Appender named " + name + " was null in logger context " + this.loggerContext), appender);
        return appender;
    }

    public Logger getRootLogger() {
        return this.loggerContext.getRootLogger();
    }

    public void reconfigure() {
        this.loggerContext.reconfigure();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("LoggerContextRule [configLocation=");
        builder.append(this.configurationLocation);
        builder.append(", contextSelectorClass=");
        builder.append(this.contextSelectorClass);
        builder.append("]");
        return builder.toString();
    }

    public RuleChain withCleanFilesRule(String ... files) {
        return RuleChain.outerRule((TestRule)new CleanFiles(files)).around((TestRule)this);
    }

    public RuleChain withCleanFoldersRule(boolean before, boolean after, int maxTries, String ... folders) {
        return RuleChain.outerRule((TestRule)new CleanFolders(before, after, maxTries, folders)).around((TestRule)this);
    }

    public RuleChain withCleanFoldersRule(String ... folders) {
        return RuleChain.outerRule((TestRule)new CleanFolders(folders)).around((TestRule)this);
    }
}

