/*
 * Decompiled with CFR 0.152.
 */
package io.openmessaging.rocketmq.domain;

import io.openmessaging.BytesMessage;
import io.openmessaging.KeyValue;
import io.openmessaging.Message;
import io.openmessaging.OMS;
import io.openmessaging.exception.OMSMessageFormatException;
import org.apache.commons.lang3.builder.ToStringBuilder;

public class BytesMessageImpl
implements BytesMessage {
    private KeyValue sysHeaders = OMS.newKeyValue();
    private KeyValue userHeaders = OMS.newKeyValue();
    private byte[] body;

    public <T> T getBody(Class<T> type) throws OMSMessageFormatException {
        if (type == byte[].class) {
            return (T)this.body;
        }
        throw new OMSMessageFormatException("", "Cannot assign byte[] to " + type.getName());
    }

    public BytesMessage setBody(byte[] body) {
        this.body = body;
        return this;
    }

    public KeyValue sysHeaders() {
        return this.sysHeaders;
    }

    public KeyValue userHeaders() {
        return this.userHeaders;
    }

    public Message putSysHeaders(String key, int value) {
        this.sysHeaders.put(key, value);
        return this;
    }

    public Message putSysHeaders(String key, long value) {
        this.sysHeaders.put(key, value);
        return this;
    }

    public Message putSysHeaders(String key, double value) {
        this.sysHeaders.put(key, value);
        return this;
    }

    public Message putSysHeaders(String key, String value) {
        this.sysHeaders.put(key, value);
        return this;
    }

    public Message putUserHeaders(String key, int value) {
        this.userHeaders.put(key, value);
        return this;
    }

    public Message putUserHeaders(String key, long value) {
        this.userHeaders.put(key, value);
        return this;
    }

    public Message putUserHeaders(String key, double value) {
        this.userHeaders.put(key, value);
        return this;
    }

    public Message putUserHeaders(String key, String value) {
        this.userHeaders.put(key, value);
        return this;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }
}

