/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.writer;

import com.alibaba.fastjson2.JSONException;
import com.alibaba.fastjson2.JSONWriter;
import com.alibaba.fastjson2.writer.FieldWriter;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

final class FieldWriterCharMethod<T>
extends FieldWriter<T> {
    FieldWriterCharMethod(String fieldName, int ordinal, long features, String format, String label, Field field, Method method, Class fieldClass) {
        super(fieldName, ordinal, features, format, label, fieldClass, fieldClass, field, method);
    }

    @Override
    public Object getFieldValue(T object) {
        try {
            return this.method.invoke(object, new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            throw new JSONException("invoke getter method error, " + this.fieldName, e);
        }
    }

    @Override
    public void writeValue(JSONWriter jsonWriter, T object) {
        Character value = (Character)this.getFieldValue(object);
        if (value == null) {
            jsonWriter.writeNull();
            return;
        }
        jsonWriter.writeChar(value.charValue());
    }

    @Override
    public boolean write(JSONWriter jsonWriter, T object) {
        Character value = (Character)this.getFieldValue(object);
        if (value == null) {
            return false;
        }
        this.writeFieldName(jsonWriter);
        jsonWriter.writeChar(value.charValue());
        return true;
    }
}

