/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.store;

import org.apache.rocketmq.store.AppendMessageResult;
import org.apache.rocketmq.store.PutMessageStatus;

public class PutMessageResult {
    private PutMessageStatus putMessageStatus;
    private AppendMessageResult appendMessageResult;
    private boolean remotePut = false;

    public PutMessageResult(PutMessageStatus putMessageStatus, AppendMessageResult appendMessageResult) {
        this.putMessageStatus = putMessageStatus;
        this.appendMessageResult = appendMessageResult;
    }

    public PutMessageResult(PutMessageStatus putMessageStatus, AppendMessageResult appendMessageResult, boolean remotePut) {
        this.putMessageStatus = putMessageStatus;
        this.appendMessageResult = appendMessageResult;
        this.remotePut = remotePut;
    }

    public boolean isOk() {
        if (this.remotePut) {
            return this.putMessageStatus == PutMessageStatus.PUT_OK || this.putMessageStatus == PutMessageStatus.FLUSH_DISK_TIMEOUT || this.putMessageStatus == PutMessageStatus.FLUSH_SLAVE_TIMEOUT || this.putMessageStatus == PutMessageStatus.SLAVE_NOT_AVAILABLE;
        }
        return this.appendMessageResult != null && this.appendMessageResult.isOk();
    }

    public AppendMessageResult getAppendMessageResult() {
        return this.appendMessageResult;
    }

    public void setAppendMessageResult(AppendMessageResult appendMessageResult) {
        this.appendMessageResult = appendMessageResult;
    }

    public PutMessageStatus getPutMessageStatus() {
        return this.putMessageStatus;
    }

    public void setPutMessageStatus(PutMessageStatus putMessageStatus) {
        this.putMessageStatus = putMessageStatus;
    }

    public boolean isRemotePut() {
        return this.remotePut;
    }

    public void setRemotePut(boolean remotePut) {
        this.remotePut = remotePut;
    }

    public String toString() {
        return "PutMessageResult [putMessageStatus=" + (Object)((Object)this.putMessageStatus) + ", appendMessageResult=" + this.appendMessageResult + ", remotePut=" + this.remotePut + "]";
    }
}

