/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.store.queue;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.rocketmq.common.message.MessageExtBrokerInner;
import org.apache.rocketmq.logging.org.slf4j.Logger;
import org.apache.rocketmq.logging.org.slf4j.LoggerFactory;
import org.apache.rocketmq.store.DefaultMessageStore;
import org.apache.rocketmq.store.DispatchRequest;
import org.apache.rocketmq.store.config.MessageStoreConfig;
import org.apache.rocketmq.store.exception.ConsumeQueueException;
import org.apache.rocketmq.store.queue.ConsumeQueueInterface;
import org.apache.rocketmq.store.queue.ConsumeQueueStoreInterface;
import org.apache.rocketmq.store.queue.CqUnit;
import org.apache.rocketmq.store.queue.QueueOffsetOperator;
import org.rocksdb.RocksDBException;

public abstract class AbstractConsumeQueueStore
implements ConsumeQueueStoreInterface {
    protected static final Logger log = LoggerFactory.getLogger((String)"RocketmqStore");
    protected final DefaultMessageStore messageStore;
    protected final MessageStoreConfig messageStoreConfig;
    protected final QueueOffsetOperator queueOffsetOperator = new QueueOffsetOperator();
    protected final ConcurrentMap<String, ConcurrentMap<Integer, ConsumeQueueInterface>> consumeQueueTable;

    public AbstractConsumeQueueStore(DefaultMessageStore messageStore) {
        this.messageStore = messageStore;
        this.messageStoreConfig = messageStore.getMessageStoreConfig();
        this.consumeQueueTable = this.messageStoreConfig.isEnableLmq() ? new ConcurrentHashMap<String, ConcurrentMap<Integer, ConsumeQueueInterface>>(32768) : new ConcurrentHashMap<String, ConcurrentMap<Integer, ConsumeQueueInterface>>(32);
    }

    public void putMessagePositionInfoWrapper(ConsumeQueueInterface consumeQueue, DispatchRequest request) {
        consumeQueue.putMessagePositionInfoWrapper(request);
    }

    @Override
    public Long getMaxOffset(String topic, int queueId) throws ConsumeQueueException {
        return this.queueOffsetOperator.currentQueueOffset(topic + "-" + queueId);
    }

    public void setTopicQueueTable(ConcurrentMap<String, Long> topicQueueTable) {
        this.queueOffsetOperator.setTopicQueueTable(topicQueueTable);
        this.queueOffsetOperator.setLmqTopicQueueTable(topicQueueTable);
    }

    @Override
    public void assignQueueOffset(MessageExtBrokerInner msg) throws RocksDBException {
        ConsumeQueueInterface consumeQueue = this.findOrCreateConsumeQueue(msg.getTopic(), msg.getQueueId());
        consumeQueue.assignQueueOffset(this.queueOffsetOperator, msg);
    }

    @Override
    public void increaseQueueOffset(MessageExtBrokerInner msg, short messageNum) {
        ConsumeQueueInterface consumeQueue = this.findOrCreateConsumeQueue(msg.getTopic(), msg.getQueueId());
        consumeQueue.increaseQueueOffset(this.queueOffsetOperator, msg, messageNum);
    }

    @Override
    public void increaseLmqOffset(String topic, int queueId, short delta) throws ConsumeQueueException {
        this.queueOffsetOperator.increaseLmqOffset(topic, queueId, delta);
    }

    @Override
    public long getLmqQueueOffset(String topic, int queueId) throws ConsumeQueueException {
        return this.queueOffsetOperator.getLmqOffset(topic, queueId, (t, q) -> 0L);
    }

    public void removeTopicQueueTable(String topic, Integer queueId) {
        this.queueOffsetOperator.remove(topic, queueId);
    }

    @Override
    public ConcurrentMap<String, ConcurrentMap<Integer, ConsumeQueueInterface>> getConsumeQueueTable() {
        return this.consumeQueueTable;
    }

    public long getStoreTime(CqUnit cqUnit) {
        if (cqUnit != null) {
            try {
                long phyOffset = cqUnit.getPos();
                int size = cqUnit.getSize();
                return this.messageStore.getCommitLog().pickupStoreTimestamp(phyOffset, size);
            }
            catch (Exception e) {
                log.error("Failed to getStoreTime", (Throwable)e);
            }
        }
        return -1L;
    }

    public abstract long getMaxPhyOffsetInConsumeQueue() throws RocksDBException;

    protected abstract void destroy(ConsumeQueueInterface var1) throws RocksDBException;

    @Override
    public boolean deleteTopic(String topic) {
        ConcurrentMap queueTable = (ConcurrentMap)this.consumeQueueTable.get(topic);
        if (queueTable == null || queueTable.isEmpty()) {
            return false;
        }
        for (ConsumeQueueInterface cq : queueTable.values()) {
            try {
                this.destroy(cq);
            }
            catch (RocksDBException e) {
                log.error("DeleteTopic: ConsumeQueue cleans error!, topic={}, queueId={}", new Object[]{cq.getTopic(), cq.getQueueId(), e});
            }
            log.info("DeleteTopic: ConsumeQueue has been cleaned, topic={}, queueId={}", (Object)cq.getTopic(), (Object)cq.getQueueId());
            this.removeTopicQueueTable(cq.getTopic(), cq.getQueueId());
        }
        this.consumeQueueTable.remove(topic);
        return true;
    }
}

